/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;

public class ObjectiveManager<V extends Variable, N extends Number>
implements ICause {
    protected final ResolutionPolicy policy;
    protected final boolean strict;
    protected final V objective;
    private final boolean intOrReal;
    private final double precision;
    protected N bestProvedLB;
    protected N bestProvedUB;

    public static ObjectiveManager SAT() {
        return new ObjectiveManager(null, ResolutionPolicy.SATISFACTION, false);
    }

    private ObjectiveManager(V objective, ResolutionPolicy policy, double precision, boolean strict, boolean intOrReal) {
        this.policy = policy;
        this.strict = strict;
        this.objective = objective;
        this.precision = precision;
        this.intOrReal = intOrReal;
        if (this.isOptimization()) {
            this.bestProvedLB = this.getObjLB();
            this.bestProvedUB = this.getObjUB();
        }
    }

    public ObjectiveManager(IntVar objective, ResolutionPolicy policy, boolean strict) {
        this(objective, policy, 0.0, strict, true);
    }

    public ObjectiveManager(RealVar objective, ResolutionPolicy policy, double precision, boolean strict) {
        this(objective, policy, precision, strict, false);
    }

    public boolean isOptimization() {
        return this.policy != ResolutionPolicy.SATISFACTION;
    }

    public void apply(Decision decision) throws ContradictionException {
        decision.apply();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction val, Explanation e) {
        if (this.isOptimization()) {
            this.objective.explain(xengine, VariableState.DOM, e);
        }
    }

    public String toString() {
        String st;
        switch (this.policy) {
            case SATISFACTION: {
                return "SAT";
            }
            case MINIMIZE: {
                st = "Minimize";
                break;
            }
            case MAXIMIZE: {
                st = "Maximize";
                break;
            }
            default: {
                throw new UnsupportedOperationException("no objective manager");
            }
        }
        if (this.intOrReal) {
            return String.format(st + " %s = %d", this.objective.getName(), this.getBestSolutionValue());
        }
        return String.format(st + " %s = %." + this.getNbDecimals() + "f", this.objective.getName(), this.getBestSolutionValue());
    }

    protected int getNbDecimals() {
        int dec = 0;
        double p = this.precision;
        while ((int)p <= 0 && dec <= 12) {
            ++dec;
            p *= 10.0;
        }
        return dec;
    }

    public void update() {
        if (this.isOptimization()) {
            assert (this.objective.isInstantiated());
            if (this.policy == ResolutionPolicy.MINIMIZE) {
                this.bestProvedUB = this.getObjUB();
            } else {
                this.bestProvedLB = this.getObjLB();
            }
        }
    }

    public void postDynamicCut() throws ContradictionException {
        if (this.isOptimization()) {
            if (this.intOrReal) {
                int offset = 0;
                if (this.objective.getSolver().getMeasures().getSolutionCount() > 0L && this.strict) {
                    offset = 1;
                }
                IntVar io = (IntVar)this.objective;
                if (this.policy == ResolutionPolicy.MINIMIZE) {
                    io.updateUpperBound(((Number)this.bestProvedUB).intValue() - offset, this);
                    io.updateLowerBound(((Number)this.bestProvedLB).intValue(), this);
                } else {
                    io.updateUpperBound(((Number)this.bestProvedUB).intValue(), this);
                    io.updateLowerBound(((Number)this.bestProvedLB).intValue() + offset, this);
                }
            } else {
                double offset = 0.0;
                if (this.objective.getSolver().getMeasures().getSolutionCount() > 0L && this.strict) {
                    offset = this.precision;
                }
                RealVar io = (RealVar)this.objective;
                if (this.policy == ResolutionPolicy.MINIMIZE) {
                    io.updateUpperBound(((Number)this.bestProvedUB).doubleValue() - offset, this);
                    io.updateLowerBound(((Number)this.bestProvedLB).doubleValue(), this);
                } else {
                    io.updateUpperBound(((Number)this.bestProvedUB).doubleValue(), this);
                    io.updateLowerBound(((Number)this.bestProvedLB).doubleValue() + offset, this);
                }
            }
        }
    }

    public N getBestSolutionValue() {
        if (this.policy == ResolutionPolicy.MINIMIZE) {
            return this.bestProvedUB;
        }
        if (this.policy == ResolutionPolicy.MAXIMIZE) {
            return this.bestProvedLB;
        }
        throw new UnsupportedOperationException("There is no objective variable in satisfaction problems");
    }

    public void updateBestLB(N lb) {
        assert (this.isOptimization());
        if (((Number)lb).doubleValue() > ((Number)this.bestProvedLB).doubleValue()) {
            this.bestProvedLB = lb;
        }
    }

    public void updateBestUB(N ub) {
        assert (this.isOptimization());
        if (((Number)ub).doubleValue() < ((Number)this.bestProvedUB).doubleValue()) {
            this.bestProvedUB = ub;
        }
    }

    private N getObjLB() {
        assert (this.isOptimization());
        if (this.intOrReal) {
            return (N)new Integer(((IntVar)this.objective).getLB());
        }
        return (N)new Double(((RealVar)this.objective).getLB());
    }

    private N getObjUB() {
        assert (this.isOptimization());
        if (this.intOrReal) {
            return (N)new Integer(((IntVar)this.objective).getUB());
        }
        return (N)new Double(((RealVar)this.objective).getUB());
    }

    public ResolutionPolicy getPolicy() {
        return this.policy;
    }

    public V getObjective() {
        return this.objective;
    }

    public N getBestLB() {
        return this.bestProvedLB;
    }

    public N getBestUB() {
        return this.bestProvedUB;
    }
}

