/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import java.io.Serializable;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IPropagationEngine
extends Serializable {
    public static final Logger LOGGER = LoggerFactory.getLogger(IPropagationEngine.class);

    public boolean isInitialized();

    public void propagate() throws ContradictionException;

    public void flush();

    public void fails(ICause var1, Variable var2, String var3) throws ContradictionException;

    public ContradictionException getContradictionException();

    public void clear();

    public void onVariableUpdate(Variable var1, IEventType var2, ICause var3) throws ContradictionException;

    public void delayedPropagation(Propagator var1, PropagatorEventType var2) throws ContradictionException;

    public void onPropagatorExecution(Propagator var1);

    public void desactivatePropagator(Propagator var1);

    public void dynamicAddition(Constraint var1, boolean var2);

    public void dynamicDeletion(Constraint var1);

    public static enum Trace {


        public static void printPropagation(Variable v, Propagator p) {
            LOGGER.debug("[P] {}", (Object)("(" + v + "::" + p + ")"));
        }

        public static void printModification(Variable v, IEventType e, ICause c) {
            LOGGER.debug("\t[M] {} {} ({})", v, e, c);
        }

        public static void printSchedule(Propagator p) {
            LOGGER.debug("\t\t[S] {}", (Object)p);
        }

        public static void printAlreadySchedule(Propagator p) {
            LOGGER.debug("\t\t[s] {}", (Object)p);
        }
    }
}

