/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation;

import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.slf4j.LoggerFactory;

public class PropagationTrigger
implements Serializable {
    final IPropagationEngine engine;
    final IEnvironment environment;
    final Solver solver;
    ArrayList<Propagator> sta_propagators = new ArrayList();
    ArrayList<Propagator> perm_propagators = new ArrayList();
    TIntArrayList perm_world = new TIntArrayList();
    int size;

    public PropagationTrigger(IPropagationEngine engine, Solver solver) {
        this.engine = engine;
        this.environment = solver.getEnvironment();
        this.solver = solver;
        this.size = 0;
    }

    public void addAll(Propagator ... propagators) {
        assert (this.perm_propagators.size() == this.perm_world.size());
        this.sta_propagators.addAll(Arrays.asList(propagators));
        this.size += propagators.length;
    }

    public void dynAdd(Propagator propagator, boolean permanent) {
        if (permanent) {
            assert (this.perm_propagators.size() == this.perm_world.size());
            this.perm_propagators.add(propagator);
            this.perm_world.add(Integer.MAX_VALUE);
            ++this.size;
        }
    }

    public void remove(Propagator propagator) {
        int idx = this.sta_propagators.indexOf(propagator);
        if (idx > -1) {
            this.sta_propagators.remove(idx);
        }
        if ((idx = this.perm_propagators.indexOf(propagator)) > -1) {
            this.perm_propagators.remove(idx);
            this.perm_world.removeAt(idx);
        }
    }

    public boolean needToRun() {
        return this.size > 0;
    }

    public void propagate() throws ContradictionException {
        if (this.sta_propagators.size() > 0) {
            for (int p = 0; p < this.sta_propagators.size(); ++p) {
                PropagationTrigger.execute(this.sta_propagators.get(p), this.engine);
            }
            this.size -= this.sta_propagators.size();
            this.sta_propagators.clear();
        }
        if (this.perm_propagators.size() > 0) {
            int cw = this.environment.getWorldIndex();
            for (int p = 0; p < this.perm_propagators.size(); ++p) {
                if (this.perm_world.getQuick(p) < cw) continue;
                PropagationTrigger.execute(this.perm_propagators.get(p), this.engine);
                this.perm_world.replace(p, cw);
            }
        }
    }

    public static void execute(Propagator toPropagate, IPropagationEngine engine) throws ContradictionException {
        if (LoggerFactory.getLogger(IPropagationEngine.class).isDebugEnabled()) {
            LoggerFactory.getLogger(IPropagationEngine.class).debug("[A] {}", (Object)toPropagate);
        }
        if (toPropagate.isStateLess()) {
            toPropagate.setActive();
            toPropagate.propagate(PropagatorEventType.FULL_PROPAGATION.getStrengthenedMask());
            engine.onPropagatorExecution(toPropagate);
        }
    }
}

