/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.slf4j.LoggerFactory;

class FakeEngine
implements IPropagationEngine {
    private static FakeEngine singleton = new FakeEngine();

    FakeEngine() {
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public void propagate() throws ContradictionException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void fails(ICause cause, Variable variable, String message) throws ContradictionException {
        throw new SolverException("The Propagator " + cause + " is not idempotent!\n" + "See stack trace for more details -- it can be due to a view!");
    }

    @Override
    public ContradictionException getContradictionException() {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) throws ContradictionException {
        throw new SolverException("The Propagator " + cause + " is not idempotent!");
    }

    @Override
    public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
    }

    @Override
    public void onPropagatorExecution(Propagator propagator) {
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
    }

    @Override
    public void dynamicAddition(Constraint c, boolean permanent) {
    }

    @Override
    public void dynamicDeletion(Constraint c) {
    }

    public static void checkIdempotency(Propagator lastProp) throws ContradictionException {
        if (LoggerFactory.getLogger(IPropagationEngine.class).isDebugEnabled()) {
            IPropagationEngine.Trace.printPropagation(null, lastProp);
        }
        switch (lastProp.getSolver().getSettings().getIdempotencyStrategy()) {
            case force: {
                if (!lastProp.isActive()) break;
                lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
                break;
            }
            case error: {
                IPropagationEngine engine = lastProp.getSolver().getEngine();
                lastProp.getSolver().set(singleton);
                if (lastProp.isActive()) {
                    lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
                }
                lastProp.getSolver().set(engine);
            }
        }
    }
}

