/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded;

import java.util.ArrayList;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.propagation.hardcoded.FakeEngine;
import org.chocosolver.solver.propagation.hardcoded.util.IId2AbId;
import org.chocosolver.solver.propagation.hardcoded.util.MId2AbId;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.objects.queues.CircularQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenQueuesPropagatorEngine
implements IPropagationEngine {
    final Logger LOGGER = LoggerFactory.getLogger(SevenQueuesPropagatorEngine.class);
    private static final int WORD_MASK = -1;
    protected final ContradictionException exception = new ContradictionException();
    protected final IEnvironment environment;
    protected final Variable[] variables;
    protected Propagator[] propagators;
    protected final CircularQueue<Propagator>[] pro_queue;
    protected Propagator lastProp;
    protected final IId2AbId p2i;
    protected int notEmpty;
    protected short[] scheduled;
    protected IntCircularQueue[] eventsets;
    private boolean init;
    protected int[][] eventmasks;
    final PropagationTrigger trigger;
    final Settings.Idem idemStrat;

    public SevenQueuesPropagatorEngine(Solver solver) {
        int i;
        this.environment = solver.getEnvironment();
        this.trigger = new PropagationTrigger(this, solver);
        this.idemStrat = solver.getSettings().getIdempotencyStrategy();
        this.variables = solver.getVars();
        ArrayList<Propagator> _propagators = new ArrayList<Propagator>();
        Constraint[] constraints = solver.getCstrs();
        int nbProp = 0;
        int m = Integer.MAX_VALUE;
        int M = 0;
        for (int c = 0; c < constraints.length; ++c) {
            Propagator[] cprops = constraints[c].getPropagators();
            int j = 0;
            while (j < cprops.length) {
                _propagators.add(cprops[j]);
                int id = cprops[j].getId();
                m = Math.min(m, id);
                M = Math.max(M, id);
                ++j;
                ++nbProp;
            }
        }
        this.propagators = _propagators.toArray(new Propagator[_propagators.size()]);
        this.trigger.addAll(this.propagators);
        this.p2i = new MId2AbId(M - m + 1, -1);
        for (int j = 0; j < this.propagators.length; ++j) {
            this.p2i.set(this.propagators[j].getId(), j);
        }
        this.pro_queue = new CircularQueue[8];
        for (i = 0; i < 8; ++i) {
            this.pro_queue[i] = new CircularQueue(16);
        }
        this.scheduled = new short[nbProp];
        this.eventsets = new IntCircularQueue[nbProp];
        this.eventmasks = new int[nbProp][];
        for (i = 0; i < nbProp; ++i) {
            int nbv = this.propagators[i].getNbVars();
            if (!this.propagators[i].reactToFineEvent()) continue;
            this.eventsets[i] = new IntCircularQueue(nbv);
            this.eventmasks[i] = new int[nbv];
        }
        this.notEmpty = 0;
        this.init = true;
    }

    @Override
    public void fails(ICause cause, Variable variable, String message) throws ContradictionException {
        throw this.exception.set(cause, variable, message);
    }

    @Override
    public ContradictionException getContradictionException() {
        return this.exception;
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.trigger.needToRun()) {
            this.trigger.propagate();
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            while (!this.pro_queue[i].isEmpty()) {
                this.lastProp = this.pro_queue[i].pollFirst();
                int aid = this.p2i.get(this.lastProp.getId());
                this.scheduled[aid] = 0;
                if (this.lastProp.reactToFineEvent()) {
                    IntCircularQueue evtset = this.eventsets[aid];
                    while (evtset.size() > 0) {
                        int v = evtset.pollFirst();
                        assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
                        if (this.LOGGER.isDebugEnabled()) {
                            IPropagationEngine.Trace.printPropagation(this.lastProp.getVar(v), this.lastProp);
                        }
                        int mask = this.eventmasks[aid][v];
                        this.eventmasks[aid][v] = 0;
                        this.lastProp.decNbPendingEvt();
                        ++this.lastProp.fineERcalls;
                        this.lastProp.propagate(v, mask);
                    }
                } else if (this.lastProp.isActive()) {
                    if (this.LOGGER.isDebugEnabled()) {
                        IPropagationEngine.Trace.printPropagation(null, this.lastProp);
                    }
                    this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
                }
                if (Settings.Idem.disabled == this.idemStrat) continue;
                FakeEngine.checkIdempotency(this.lastProp);
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(0);
        }
    }

    private int nextNotEmpty(int fromIndex) {
        int word = this.notEmpty & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public void flush() {
        IntCircularQueue evtset;
        int aid;
        if (this.lastProp != null) {
            aid = this.p2i.get(this.lastProp.getId());
            if (this.lastProp.reactToFineEvent()) {
                evtset = this.eventsets[aid];
                while (evtset.size() > 0) {
                    int v = evtset.pollFirst();
                    this.eventmasks[aid][v] = 0;
                }
                evtset.clear();
                this.lastProp.flushPendingEvt();
            }
            this.scheduled[aid] = 0;
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            while (!this.pro_queue[i].isEmpty()) {
                this.lastProp = this.pro_queue[i].pollFirst();
                aid = this.p2i.get(this.lastProp.getId());
                if (this.lastProp.reactToFineEvent()) {
                    evtset = this.eventsets[aid];
                    while (evtset.size() > 0) {
                        int v = evtset.pollFirst();
                        this.eventmasks[aid][v] = 0;
                    }
                    evtset.clear();
                    this.lastProp.flushPendingEvt();
                }
                this.scheduled[aid] = 0;
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(i + 1);
        }
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) throws ContradictionException {
        if (this.LOGGER.isDebugEnabled()) {
            IPropagationEngine.Trace.printModification(variable, type, cause);
        }
        Propagator[] vpropagators = variable.getPropagators();
        int nbp = vpropagators.length;
        int[] vindices = variable.getPIndices();
        for (int p = nbp - 1; p >= 0; --p) {
            Propagator prop = vpropagators[p];
            int pindice = vindices[p];
            if (cause == prop || !prop.isActive() || !prop.advise(pindice, type.getMask())) continue;
            int aid = this.p2i.get(prop.getId());
            if (prop.reactToFineEvent()) {
                boolean needSched = this.eventmasks[aid][pindice] == 0;
                int[] nArray = this.eventmasks[aid];
                int n = pindice;
                nArray[n] = nArray[n] | type.getStrengthenedMask();
                if (needSched) {
                    if (this.LOGGER.isDebugEnabled()) {
                        IPropagationEngine.Trace.printSchedule(prop);
                    }
                    prop.incNbPendingEvt();
                    this.eventsets[aid].addLast(pindice);
                } else if (this.LOGGER.isDebugEnabled()) {
                    IPropagationEngine.Trace.printAlreadySchedule(prop);
                }
            }
            if (this.scheduled[aid] != 0) continue;
            int prio = prop.getPriority().priority;
            this.pro_queue[prio].addLast(prop);
            this.scheduled[aid] = (short)(prio + 1);
            this.notEmpty |= 1 << prio;
        }
    }

    @Override
    public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
        if (propagator.getNbPendingEvt() == 0) {
            if (this.LOGGER.isDebugEnabled()) {
                IPropagationEngine.Trace.printPropagation(null, propagator);
            }
            ++propagator.coarseERcalls;
            propagator.propagate(type.getStrengthenedMask());
        }
    }

    @Override
    public void onPropagatorExecution(Propagator propagator) {
        this.desactivatePropagator(propagator);
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
        int pid;
        int aid;
        if (propagator.reactToFineEvent() && (aid = this.p2i.get(pid = propagator.getId())) > -1) {
            assert (aid > -1) : "try to desactivate an unknown constraint";
            IntCircularQueue evtset = this.eventsets[aid];
            while (evtset.size() > 0) {
                int v = evtset.pollFirst();
                this.eventmasks[aid][v] = 0;
            }
            evtset.clear();
            propagator.flushPendingEvt();
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void dynamicAddition(Constraint c, boolean permanent) {
        int osize = this.propagators.length;
        int nbp = c.getPropagators().length;
        int nsize = osize + nbp;
        Propagator[] _propagators = this.propagators;
        this.propagators = new Propagator[nsize];
        System.arraycopy(_propagators, 0, this.propagators, 0, osize);
        System.arraycopy(c.getPropagators(), 0, this.propagators, osize, nbp);
        for (int j = osize; j < nsize; ++j) {
            this.p2i.set(this.propagators[j].getId(), j);
            this.trigger.dynAdd(this.propagators[j], permanent);
        }
        short[] _scheduled = this.scheduled;
        this.scheduled = new short[nsize];
        System.arraycopy(_scheduled, 0, this.scheduled, 0, osize);
        IntCircularQueue[] _eventsets = this.eventsets;
        this.eventsets = new IntCircularQueue[nsize];
        System.arraycopy(_eventsets, 0, this.eventsets, 0, osize);
        int[][] _eventmasks = this.eventmasks;
        this.eventmasks = new int[nsize][];
        System.arraycopy(_eventmasks, 0, this.eventmasks, 0, osize);
        for (int i = osize; i < nsize; ++i) {
            if (!this.propagators[i].reactToFineEvent()) continue;
            int nbv = this.propagators[i].getNbVars();
            this.eventsets[i] = new IntCircularQueue(nbv);
            this.eventmasks[i] = new int[nbv];
        }
    }

    @Override
    public void dynamicDeletion(Constraint c) {
        for (Propagator toDelete : c.getPropagators()) {
            int nsize = this.propagators.length - 1;
            Propagator toMove = this.propagators[nsize];
            int idtd = this.p2i.get(toDelete.getId());
            int idtm = this.p2i.get(toMove.getId());
            assert (idtd <= idtm) : "wrong id for prop to delete";
            Propagator[] _propagators = this.propagators;
            this.propagators = new Propagator[nsize];
            System.arraycopy(_propagators, 0, this.propagators, 0, nsize);
            short stm = this.scheduled[idtm];
            assert (this.scheduled[idtd] == 0) : "try to delete a propagator which is scheduled (fine)";
            short[] _scheduled = this.scheduled;
            this.scheduled = new short[nsize];
            System.arraycopy(_scheduled, 0, this.scheduled, 0, nsize);
            IntCircularQueue estm = this.eventsets[idtm];
            assert (!toDelete.reactToFineEvent() || this.eventsets[idtd].isEmpty()) : "try to delete a propagator which has events to propagate (fine)";
            IntCircularQueue[] _eventsets = this.eventsets;
            this.eventsets = new IntCircularQueue[nsize];
            System.arraycopy(_eventsets, 0, this.eventsets, 0, nsize);
            int[] emtm = this.eventmasks[idtm];
            int[][] _eventmasks = this.eventmasks;
            this.eventmasks = new int[nsize][];
            System.arraycopy(_eventmasks, 0, this.eventmasks, 0, nsize);
            if (idtd < nsize) {
                this.propagators[idtd] = toMove;
                this.p2i.set(toMove.getId(), idtd);
                this.scheduled[idtd] = stm;
                this.eventsets[idtd] = estm;
                this.eventmasks[idtd] = emtm;
            }
            this.trigger.remove(toDelete);
        }
    }
}

