/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.propagation.hardcoded.FakeEngine;
import org.chocosolver.solver.propagation.hardcoded.util.IId2AbId;
import org.chocosolver.solver.propagation.hardcoded.util.MId2AbId;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.IntCircularQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoBucketPropagationEngine
implements IPropagationEngine {
    final Logger LOGGER = LoggerFactory.getLogger(TwoBucketPropagationEngine.class);
    private static final int WORD_MASK = -1;
    private final short[] match_f;
    private final short[] match_c;
    private final short max_f;
    private final short max_c;
    protected final ContradictionException exception = new ContradictionException();
    protected final IEnvironment environment;
    protected final Variable[] variables;
    protected Propagator[] propagators;
    protected final IId2AbId p2i;
    protected Propagator lastProp;
    protected int notEmpty;
    protected final ArrayDeque<Propagator>[] pro_queue_f;
    protected boolean[] schedule_f;
    protected IntCircularQueue[] event_f;
    protected int[][] eventmasks;
    protected final ArrayDeque<Propagator>[] pro_queue_c;
    protected boolean[] schedule_c;
    protected PropagatorEventType[] event_c;
    private boolean init;
    final PropagationTrigger trigger;
    final Settings.Idem idemStrat;

    public TwoBucketPropagationEngine(Solver solver) {
        int i;
        this.environment = solver.getEnvironment();
        this.trigger = new PropagationTrigger(this, solver);
        this.idemStrat = solver.getSettings().getIdempotencyStrategy();
        this.variables = solver.getVars();
        ArrayList<Propagator> _propagators = new ArrayList<Propagator>();
        Constraint[] constraints = solver.getCstrs();
        int nbProp = 0;
        int m = Integer.MAX_VALUE;
        int M = 0;
        for (int c = 0; c < constraints.length; ++c) {
            Propagator[] cprops = constraints[c].getPropagators();
            int j = 0;
            while (j < cprops.length) {
                _propagators.add(cprops[j]);
                int id = cprops[j].getId();
                m = Math.min(m, id);
                M = Math.max(M, id);
                ++j;
                ++nbProp;
            }
        }
        this.propagators = _propagators.toArray(new Propagator[_propagators.size()]);
        this.p2i = new MId2AbId(M - m + 1, -1);
        for (int j = 0; j < this.propagators.length; ++j) {
            this.p2i.set(this.propagators[j].getId(), j);
        }
        this.trigger.addAll(this.propagators);
        this.match_f = solver.getSettings().getFineEventPriority();
        this.match_c = solver.getSettings().getCoarseEventPriority();
        short _max_ = -1;
        for (i = 0; i < this.match_f.length; ++i) {
            if (_max_ >= this.match_f[i]) continue;
            _max_ = this.match_f[i];
        }
        this.max_f = _max_ = (short)((short)(_max_ + 1));
        _max_ = -1;
        for (i = 0; i < this.match_c.length; ++i) {
            if (_max_ >= this.match_c[i]) continue;
            _max_ = this.match_c[i];
        }
        this.max_c = _max_ = (short)((short)(_max_ + 1));
        this.pro_queue_f = new ArrayDeque[this.max_f];
        for (i = 0; i < this.max_f; ++i) {
            this.pro_queue_f[i] = new ArrayDeque(this.propagators.length / 2 + 1);
        }
        this.schedule_f = new boolean[nbProp];
        this.pro_queue_c = new ArrayDeque[this.max_c];
        for (i = 0; i < this.max_c; ++i) {
            this.pro_queue_c[i] = new ArrayDeque(this.propagators.length / 2 + 1);
        }
        this.schedule_c = new boolean[nbProp];
        this.notEmpty = 0;
        this.event_f = new IntCircularQueue[nbProp];
        this.eventmasks = new int[nbProp][];
        for (i = 0; i < nbProp; ++i) {
            if (!this.propagators[i].reactToFineEvent()) continue;
            int nbv = this.propagators[i].getNbVars();
            this.event_f[i] = new IntCircularQueue(nbv);
            this.eventmasks[i] = new int[nbv];
        }
        this.event_c = new PropagatorEventType[nbProp];
        Arrays.fill(this.event_c, PropagatorEventType.VOID);
        this.init = true;
    }

    @Override
    public void fails(ICause cause, Variable variable, String message) throws ContradictionException {
        throw this.exception.set(cause, variable, message);
    }

    @Override
    public ContradictionException getContradictionException() {
        return this.exception;
    }

    @Override
    public boolean isInitialized() {
        return this.init;
    }

    @Override
    public void propagate() throws ContradictionException {
        if (this.trigger.needToRun()) {
            this.trigger.propagate();
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            if (i == 0) {
                while (!this.pro_queue_f[i].isEmpty()) {
                    this.propagateFine(this.pro_queue_f[i]);
                }
                this.notEmpty &= 0xFFFFFFFE;
            } else if (i < this.max_f) {
                this.propagateFine(this.pro_queue_f[i]);
                if (this.pro_queue_f[i].isEmpty()) {
                    this.notEmpty &= ~(1 << i);
                }
            } else {
                int j = i - this.max_f;
                this.propagateCoarse(this.pro_queue_c[j]);
                if (this.pro_queue_c[j].isEmpty()) {
                    this.notEmpty &= ~(1 << i);
                }
            }
            i = this.nextNotEmpty(0);
        }
    }

    private int nextNotEmpty(int fromIndex) {
        int word = this.notEmpty & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    private void propagateFine(ArrayDeque<Propagator> pro_queue_f) throws ContradictionException {
        this.lastProp = pro_queue_f.pollFirst();
        int aid = this.p2i.get(this.lastProp.getId());
        this.schedule_f[aid] = false;
        if (this.lastProp.reactToFineEvent()) {
            IntCircularQueue evtset = this.event_f[aid];
            while (!evtset.isEmpty()) {
                int v = evtset.pollFirst();
                assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
                if (this.LOGGER.isDebugEnabled()) {
                    IPropagationEngine.Trace.printPropagation(this.lastProp.getVar(v), this.lastProp);
                }
                int mask = this.eventmasks[aid][v];
                this.eventmasks[aid][v] = 0;
                ++this.lastProp.fineERcalls;
                this.lastProp.propagate(v, mask);
            }
        } else if (this.lastProp.isActive()) {
            if (this.LOGGER.isDebugEnabled()) {
                IPropagationEngine.Trace.printPropagation(null, this.lastProp);
            }
            this.lastProp.propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
        }
        if (Settings.Idem.disabled != this.idemStrat) {
            FakeEngine.checkIdempotency(this.lastProp);
        }
    }

    private void propagateCoarse(ArrayDeque<Propagator> pro_queue_c) throws ContradictionException {
        this.lastProp = pro_queue_c.pollFirst();
        int aid = this.p2i.get(this.lastProp.getId());
        assert (this.schedule_c[aid]) : "try to propagate an unscheduled propagator";
        this.schedule_c[aid] = false;
        PropagatorEventType evt = this.event_c[aid];
        this.event_c[aid] = PropagatorEventType.VOID;
        assert (this.lastProp.isActive()) : "propagator is not active:" + this.lastProp;
        if (this.LOGGER.isDebugEnabled()) {
            IPropagationEngine.Trace.printPropagation(null, this.lastProp);
        }
        ++this.lastProp.coarseERcalls;
        this.lastProp.propagate(evt.getStrengthenedMask());
    }

    @Override
    public void flush() {
        if (this.lastProp != null) {
            this.flushFine();
            this.flushCoarse();
        }
        int i = this.nextNotEmpty(0);
        while (i > -1) {
            if (i < this.max_f) {
                while (!this.pro_queue_f[i].isEmpty()) {
                    this.lastProp = this.pro_queue_f[i].pollLast();
                    this.flushFine();
                }
            } else {
                while (!this.pro_queue_c[i - this.max_f].isEmpty()) {
                    this.lastProp = this.pro_queue_c[i - this.max_f].pollLast();
                    this.flushCoarse();
                }
            }
            this.notEmpty &= ~(1 << i);
            i = this.nextNotEmpty(0);
        }
    }

    private void flushFine() {
        int aid = this.p2i.get(this.lastProp.getId());
        if (this.lastProp.reactToFineEvent()) {
            IntCircularQueue evtset = this.event_f[aid];
            while (!evtset.isEmpty()) {
                this.eventmasks[aid][evtset.pollLast()] = 0;
            }
            evtset.clear();
        }
        this.schedule_f[aid] = false;
    }

    private void flushCoarse() {
        int aid = this.p2i.get(this.lastProp.getId());
        this.schedule_c[aid] = false;
        this.event_c[aid] = PropagatorEventType.VOID;
    }

    @Override
    public void onVariableUpdate(Variable variable, IEventType type, ICause cause) throws ContradictionException {
        if (this.LOGGER.isDebugEnabled()) {
            IPropagationEngine.Trace.printModification(variable, type, cause);
        }
        int nbp = variable.getNbProps();
        for (int p = 0; p < nbp; ++p) {
            Propagator prop = variable.getPropagator(p);
            int pindice = variable.getIndexInPropagator(p);
            if (cause == prop || !prop.isActive() || !prop.advise(pindice, type.getMask())) continue;
            int aid = this.p2i.get(prop.getId());
            if (prop.reactToFineEvent()) {
                boolean needSched = this.eventmasks[aid][pindice] == 0;
                int[] nArray = this.eventmasks[aid];
                int n = pindice;
                nArray[n] = nArray[n] | type.getStrengthenedMask();
                if (needSched) {
                    if (this.LOGGER.isDebugEnabled()) {
                        IPropagationEngine.Trace.printSchedule(prop);
                    }
                    this.event_f[aid].addLast(pindice);
                } else if (this.LOGGER.isDebugEnabled()) {
                    IPropagationEngine.Trace.printAlreadySchedule(prop);
                }
            }
            if (this.schedule_f[aid]) continue;
            PropagatorPriority prio = prop.getPriority();
            short q = this.match_f[prio.priority - 1];
            this.pro_queue_f[q].addLast(prop);
            this.schedule_f[aid] = true;
            this.notEmpty |= 1 << q;
        }
    }

    @Override
    public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
        int aid = this.p2i.get(propagator.getId());
        if (!this.schedule_c[aid]) {
            PropagatorPriority prio = propagator.getPriority();
            short q = this.match_c[prio.priority - 1];
            if (q == -1) {
                throw new SolverException("Cannot schedule coarse event for low priority propagator.");
            }
            this.pro_queue_c[q].addLast(propagator);
            this.schedule_c[aid] = true;
            this.event_c[aid] = type;
            this.notEmpty |= 1 << q + this.max_f;
        }
    }

    @Override
    public void onPropagatorExecution(Propagator propagator) {
        this.lastProp = propagator;
        this.flushFine();
        this.flushCoarse();
    }

    @Override
    public void desactivatePropagator(Propagator propagator) {
        this.lastProp = propagator;
        this.flushFine();
        this.flushCoarse();
    }

    @Override
    public void clear() {
    }

    @Override
    public void dynamicAddition(Constraint c, boolean permanent) {
        int osize = this.propagators.length;
        int nbp = c.getPropagators().length;
        int nsize = osize + nbp;
        Propagator[] _propagators = this.propagators;
        this.propagators = new Propagator[nsize];
        System.arraycopy(_propagators, 0, this.propagators, 0, osize);
        System.arraycopy(c.getPropagators(), 0, this.propagators, osize, nbp);
        for (int j = osize; j < nsize; ++j) {
            this.p2i.set(this.propagators[j].getId(), j);
            this.trigger.dynAdd(this.propagators[j], permanent);
        }
        boolean[] _schedule_f = this.schedule_f;
        this.schedule_f = new boolean[nsize];
        System.arraycopy(_schedule_f, 0, this.schedule_f, 0, osize);
        boolean[] _schedule_c = this.schedule_c;
        this.schedule_c = new boolean[nsize];
        System.arraycopy(_schedule_c, 0, this.schedule_c, 0, osize);
        IntCircularQueue[] _event_f = this.event_f;
        this.event_f = new IntCircularQueue[nsize];
        System.arraycopy(_event_f, 0, this.event_f, 0, osize);
        for (int i = osize; i < nsize; ++i) {
            if (!this.propagators[i].reactToFineEvent()) continue;
            this.event_f[i] = new IntCircularQueue(this.propagators[i].getNbVars());
        }
        PropagatorEventType[] _event_c = this.event_c;
        this.event_c = new PropagatorEventType[nsize];
        System.arraycopy(_event_c, 0, this.event_c, 0, osize);
        Arrays.fill(this.event_c, osize, nsize, PropagatorEventType.VOID);
        int[][] _eventmasks = this.eventmasks;
        this.eventmasks = new int[nsize][];
        System.arraycopy(_eventmasks, 0, this.eventmasks, 0, osize);
        for (int i = osize; i < nsize; ++i) {
            if (!this.propagators[i].reactToFineEvent()) continue;
            this.eventmasks[i] = new int[this.propagators[i].getNbVars()];
        }
    }

    @Override
    public void dynamicDeletion(Constraint c) {
        for (Propagator toDelete : c.getPropagators()) {
            int nsize = this.propagators.length - 1;
            Propagator toMove = this.propagators[nsize];
            int idtd = this.p2i.get(toDelete.getId());
            int idtm = this.p2i.get(toMove.getId());
            assert (idtd <= idtm) : "wrong id for prop to delete";
            Propagator[] _propagators = this.propagators;
            this.propagators = new Propagator[nsize];
            System.arraycopy(_propagators, 0, this.propagators, 0, nsize);
            boolean sftm = this.schedule_f[idtm];
            assert (!this.schedule_f[idtd]) : "try to delete a propagator which is scheduled (fine)";
            boolean[] _schedule_f = this.schedule_f;
            this.schedule_f = new boolean[nsize];
            System.arraycopy(_schedule_f, 0, this.schedule_f, 0, nsize);
            boolean sctm = this.schedule_c[idtm];
            assert (!this.schedule_c[idtd]) : "try to delete a propagator which is scheduled (coarse)";
            boolean[] _schedule_c = this.schedule_c;
            this.schedule_c = new boolean[nsize];
            System.arraycopy(_schedule_c, 0, this.schedule_c, 0, nsize);
            IntCircularQueue icqtm = this.event_f[idtm];
            assert (!toDelete.reactToFineEvent() || this.event_f[idtd].isEmpty()) : "try to delete a propagator which has events to propagate (fine)";
            IntCircularQueue[] _event_f = this.event_f;
            this.event_f = new IntCircularQueue[nsize];
            System.arraycopy(_event_f, 0, this.event_f, 0, nsize);
            PropagatorEventType ettm = this.event_c[idtm];
            assert (this.event_c[idtd] == PropagatorEventType.VOID) : "try to delete a propagator which has events to propagate (coarse)";
            PropagatorEventType[] _event_c = this.event_c;
            this.event_c = new PropagatorEventType[nsize];
            System.arraycopy(_event_c, 0, this.event_c, 0, nsize);
            int[] emtm = this.eventmasks[idtm];
            int[][] _eventmasks = this.eventmasks;
            this.eventmasks = new int[nsize][];
            System.arraycopy(_eventmasks, 0, this.eventmasks, 0, nsize);
            if (idtd < nsize) {
                this.propagators[idtd] = toMove;
                this.p2i.set(toMove.getId(), idtd);
                this.schedule_f[idtd] = sftm;
                this.schedule_c[idtd] = sctm;
                this.event_f[idtd] = icqtm;
                this.event_c[idtd] = ettm;
                this.eventmasks[idtd] = emtm;
            }
            this.trigger.remove(toDelete);
        }
    }
}

