/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.propagation.hardcoded.util;

import java.util.Arrays;
import org.chocosolver.solver.propagation.hardcoded.util.IId2AbId;

public class AId2AbId
implements IId2AbId {
    int[] map;
    final int offset;
    final int noValue;
    int size;

    public AId2AbId(int minKey, int maxKey, int noValue) {
        this.size = Math.max(0, maxKey - minKey + 1);
        this.offset = this.size == 0 ? 0 : minKey;
        this.map = new int[this.size];
        Arrays.fill(this.map, noValue);
        this.noValue = noValue;
    }

    @Override
    public int get(int key) {
        if ((key -= this.offset) < 0 || key > this.size) {
            return this.noValue;
        }
        return this.map[key];
    }

    @Override
    public void set(int key, int value) {
        int idx = key - this.offset;
        if (idx >= this.size) {
            int[] tmp = this.map;
            this.map = new int[idx + 1];
            System.arraycopy(tmp, 0, this.map, 0, this.size);
            this.size = this.map.length;
        }
        this.map[idx] = value;
    }
}

