/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.bind;

import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.bind.ISearchBinder;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.SetStrategyFactory;
import org.chocosolver.solver.search.strategy.selectors.values.RealDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.variables.Cyclic;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.RealStrategy;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.slf4j.LoggerFactory;

public class DefaultSearchBinder
implements ISearchBinder {
    @Override
    public void configureSearch(Solver solver) {
        RealVar[] rvars;
        SetVar[] svars;
        IntVar[] bvars;
        LoggerFactory.getLogger(ISearchBinder.class).warn("No search strategies defined");
        LoggerFactory.getLogger(ISearchBinder.class).warn("Set to default ones");
        AbstractStrategy[] strats = new AbstractStrategy[5];
        int nb = 0;
        IntVar[] ivars = (IntVar[])DefaultSearchBinder.excludeConstants((Variable[])solver.retrieveIntVars());
        if (ivars.length > 0) {
            strats[nb++] = ISF.minDom_LB(ivars);
        }
        if ((bvars = (BoolVar[])DefaultSearchBinder.excludeConstants((Variable[])solver.retrieveBoolVars())).length > 0) {
            strats[nb++] = ISF.lexico_UB(bvars);
        }
        if ((svars = (SetVar[])DefaultSearchBinder.excludeConstants((Variable[])solver.retrieveSetVars())).length > 0) {
            strats[nb++] = SetStrategyFactory.force_minDelta_first(svars);
        }
        if ((rvars = (RealVar[])DefaultSearchBinder.excludeConstants((Variable[])solver.retrieveRealVars())).length > 0) {
            strats[nb] = new RealStrategy(rvars, new Cyclic(), new RealDomainMiddle());
        }
        if (nb == 0) {
            solver.set(ISF.minDom_LB(solver.ONE));
        } else {
            solver.set(Arrays.copyOf(strats, nb));
        }
    }

    private static <V extends Variable> V[] excludeConstants(V[] vars) {
        Variable[] noCsts;
        int nb = 0;
        for (V v : vars) {
            if ((v.getTypeAndKind() & 2) != 0) continue;
            ++nb;
        }
        if (nb == vars.length) {
            return vars;
        }
        switch (vars[0].getTypeAndKind() & 0xF8) {
            case 24: {
                noCsts = new BoolVar[nb];
                break;
            }
            case 8: {
                noCsts = new IntVar[nb];
                break;
            }
            case 64: {
                noCsts = new SetVar[nb];
                break;
            }
            case 128: {
                noCsts = new RealVar[nb];
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        nb = 0;
        for (V v : vars) {
            if ((v.getTypeAndKind() & 2) != 0) continue;
            noCsts[nb++] = v;
        }
        return noCsts;
    }
}

