/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.limits;

import org.chocosolver.solver.search.limits.ActionCounterFactory;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.limits.ICounterAction;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;

public abstract class ACounter
implements ICounter,
IMonitorInitialize {
    protected long max;
    protected long current;
    protected ICounterAction action;

    public ACounter(long limit) {
        this.max = limit;
        this.current = 0L;
        this.action = ActionCounterFactory.none();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
    }

    @Override
    public final void overrideLimit(long newLimit) {
        this.max = newLimit;
    }

    @Override
    public void reset() {
        this.current = 0L;
        this.init();
    }

    @Override
    public final boolean isReached() {
        return this.max - this.current <= 0L;
    }

    @Override
    public long getLimitValue() {
        return this.max;
    }

    protected final void incCounter() {
        ++this.current;
        if (this.isReached()) {
            this.action.onLimitReached();
        }
    }

    protected final void setCounter(long value) {
        this.current = value;
        if (this.isReached()) {
            this.action.onLimitReached();
        }
    }

    @Override
    public void beforeInitialize() {
    }

    @Override
    public void afterInitialize() {
        this.init();
    }

    @Override
    public void setAction(ICounterAction action) {
        this.action = action;
    }
}

