/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.limits;

import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.limits.ICounterAction;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;

public class ThreadTimeCounter
extends Thread
implements ICounter,
IMonitorOpenNode,
IMonitorInitialize {
    private long timelimit;
    private final long threshold;
    private long duration;
    private volatile boolean isreached;
    private ICounterAction action;

    public ThreadTimeCounter(long duration) {
        super("time limit");
        this.duration = duration;
        this.threshold = duration / 3L;
        this.isreached = false;
    }

    @Override
    public void init() {
        this.timelimit = System.currentTimeMillis() + this.duration;
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            long sleep = this.duration - this.threshold;
            Thread.sleep(sleep);
            do {
                long diff;
                boolean bl = this.isreached = (diff = this.timelimit - System.currentTimeMillis()) <= 0L;
            } while (!this.isreached);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isReached() {
        return this.isreached;
    }

    @Override
    public String toString() {
        return String.format("Time (ms): %d ", this.duration);
    }

    @Override
    public void update() {
    }

    @Override
    public long getLimitValue() {
        return this.duration;
    }

    @Override
    public void overrideLimit(long newLimit) {
        long diff = newLimit - this.duration;
        this.duration = newLimit;
        this.timelimit += diff;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("ThreadLimit cannot be reset");
    }

    @Override
    public void beforeOpenNode() {
        if (this.isreached) {
            this.action.onLimitReached();
        }
    }

    @Override
    public void afterOpenNode() {
    }

    @Override
    public void beforeInitialize() {
    }

    @Override
    public void afterInitialize() {
        this.init();
    }

    @Override
    public void setAction(ICounterAction action) {
        this.action = action;
    }
}

