/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.limits;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.limits.ACounter;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;

public class TimeCounter
extends ACounter
implements IMonitorOpenNode {
    private Solver solver;
    private static final int IN_NS = 1000000;
    private long offset;

    public TimeCounter(Solver solver, long timeLimit) {
        super(timeLimit * 1000000L);
        this.solver = solver;
    }

    @Override
    public void init() {
        this.solver.getMeasures().updateTimeCount();
        long time = (long)(this.solver.getMeasures().getTimeCount() * 1000000.0f);
        this.offset = System.nanoTime() - time;
    }

    @Override
    public void beforeOpenNode() {
        this.setCounter(System.nanoTime() - this.offset);
    }

    @Override
    public void afterOpenNode() {
    }
}

