/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop;

import java.util.ArrayDeque;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.StringUtils;

public enum Reporting {


    public static String onDecisions(Solver solver) {
        ISearchLoop searchLoop = solver.getSearchLoop();
        ArrayDeque<Decision> stack = new ArrayDeque<Decision>();
        for (Decision last = searchLoop.getLastDecision(); last != null; last = last.getPrevious()) {
            stack.push(last);
        }
        StringBuilder sb = new StringBuilder();
        while (!stack.isEmpty()) {
            sb.append(((Decision)stack.removeFirst()).toString()).append(" & ");
        }
        sb.append("\n").append(solver.getObjectiveManager().toString());
        return sb.toString();
    }

    public static String onUninstiatedVariables(Solver solver) {
        Variable[] variables = solver.getVars();
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < variables.length; ++c) {
            boolean insV = variables[c].isInstantiated();
            if (insV) continue;
            sb.append("FAILURE >> ").append(variables[c].toString()).append("\n");
        }
        return sb.toString();
    }

    public static String onUnsatisfiedConstraints(Solver solver) {
        Constraint[] constraints = solver.getCstrs();
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < constraints.length; ++c) {
            ESat satC = constraints[c].isSatisfied();
            if (ESat.TRUE.equals((Object)satC)) continue;
            sb.append("FAILURE >> ").append(constraints[c].toString()).append("\n");
        }
        return sb.toString();
    }

    public static String fullReport(Solver solver) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        sb.append(Reporting.onUninstiatedVariables(solver)).append("\n");
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        sb.append(Reporting.onUnsatisfiedConstraints(solver)).append("\n");
        sb.append(StringUtils.pad("", 50, "=")).append("\n");
        sb.append(Reporting.onDecisions(solver)).append("\n");
        sb.append(solver.getMeasures().toOneShortLineString());
        sb.append(StringUtils.pad("", 50, "#")).append("\n");
        return sb.toString();
    }
}

