/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.search.bind.ISearchBinder;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.loop.Reporting;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;
import org.chocosolver.solver.search.loop.monitors.SearchMonitorList;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.RootDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchLoop
implements ISearchLoop {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SearchLoop.class);
    int timeStamp;
    final Solver solver;
    IEnvironment env;
    AbstractStrategy<Variable> strategy;
    boolean stopAtFirstSolution;
    int rootWorldIndex;
    int searchWorldIndex;
    int nextState;
    int jumpTo;
    protected final IMeasures measures;
    boolean hasReachedLimit;
    public SearchMonitorList smList;
    ObjectiveManager objectivemanager;
    private boolean alive;
    public Decision decision = RootDecision.ROOT;

    public SearchLoop(Solver solver) {
        this.solver = solver;
        this.env = solver.getEnvironment();
        this.measures = solver.getMeasures();
        this.smList = new SearchMonitorList();
        this.smList.add(this.measures);
        this.nextState = 0;
        this.rootWorldIndex = -1;
    }

    @Override
    public void reset() {
        if (this.rootWorldIndex > -1) {
            this.env.worldPopUntil(this.rootWorldIndex);
            ++this.timeStamp;
            while (this.decision != RootDecision.ROOT) {
                Decision tmp = this.decision;
                this.decision = tmp.getPrevious();
                tmp.free();
            }
            this.nextState = 0;
            this.rootWorldIndex = -1;
            this.searchWorldIndex = -1;
            this.measures.reset();
            this.objectivemanager = ObjectiveManager.SAT();
            this.solver.set(NoPropagationEngine.SINGLETON);
        }
    }

    @Override
    public void launch(boolean stopatfirst) {
        if (this.nextState != 0) {
            throw new SolverException("!! The search has not been initialized.\n!! Be sure you are respecting one of these call configurations :\n \tfindSolution ( nextSolution )* | findAllSolutions | findOptimalSolution\n");
        }
        this.stopAtFirstSolution = stopatfirst;
        this.loop();
    }

    @Override
    public void resume() {
        if (this.nextState == 0) {
            throw new SolverException("the search loop has not been initialized.\n This appears when 'nextSolution' is called before 'findSolution'.");
        }
        if (this.nextState != 64) {
            throw new SolverException("The search cannot be resumed.");
        }
        this.moveTo(16);
        this.loop();
    }

    @Override
    public void moveTo(int to) {
        if ((this.nextState & 0x20) == 0) {
            this.nextState = to;
        }
    }

    @Override
    public void restoreRootNode() {
        this.env.worldPopUntil(this.searchWorldIndex);
        ++this.timeStamp;
        while (this.decision != RootDecision.ROOT) {
            Decision tmp = this.decision;
            this.decision = tmp.getPrevious();
            tmp.free();
        }
    }

    @Override
    public final void interrupt(String message) {
        this.nextState = 64;
        this.alive = false;
        this.smList.afterInterrupt();
    }

    @Override
    public final void forceAlive(boolean bvalue) {
        this.alive = bvalue;
    }

    @Override
    public final void restart() {
        this.nextState = 32;
    }

    private void loop() {
        this.alive = true;
        while (this.alive) {
            switch (this.nextState) {
                case 0: {
                    this.smList.beforeInitialize();
                    this.initialize();
                    this.smList.afterInitialize();
                    break;
                }
                case 1: {
                    this.smList.beforeInitialPropagation();
                    this.initialPropagation();
                    this.smList.afterInitialPropagation();
                    break;
                }
                case 2: {
                    this.smList.beforeOpenNode();
                    this.openNode();
                    this.smList.afterOpenNode();
                    break;
                }
                case 4: {
                    ++this.timeStamp;
                    this.smList.beforeDownLeftBranch();
                    this.downLeftBranch();
                    this.smList.afterDownLeftBranch();
                    break;
                }
                case 8: {
                    ++this.timeStamp;
                    this.smList.beforeDownRightBranch();
                    this.downRightBranch();
                    this.smList.afterDownRightBranch();
                    break;
                }
                case 16: {
                    this.smList.beforeUpBranch();
                    this.upBranch();
                    this.smList.afterUpBranch();
                    break;
                }
                case 32: {
                    this.smList.beforeRestart();
                    this.restartSearch();
                    this.smList.afterRestart();
                }
            }
        }
        this.smList.beforeClose();
        this.close();
        this.smList.afterClose();
    }

    private void initialize() {
        this.rootWorldIndex = this.env.getWorldIndex();
        this.nextState = 1;
    }

    private void initialPropagation() {
        this.env.worldPush();
        try {
            this.solver.getEngine().propagate();
        }
        catch (ContradictionException e) {
            this.env.worldPop();
            this.solver.setFeasible(ESat.FALSE);
            this.solver.getEngine().flush();
            this.interrupt("failure encountered during initial propagation");
            return;
        }
        this.env.worldPush();
        this.searchWorldIndex = this.env.getWorldIndex();
        if (this.strategy == null) {
            ISearchBinder binder = this.solver.getSettings().getSearchBinder();
            binder.configureSearch(this.solver);
        }
        try {
            this.strategy.init();
        }
        catch (ContradictionException cex) {
            this.env.worldPop();
            this.solver.setFeasible(ESat.FALSE);
            this.solver.getEngine().flush();
            this.interrupt("search strategy detects inconsistency: " + cex.getMessage());
        }
        this.moveTo(2);
    }

    private void openNode() {
        Decision tmp = this.decision;
        this.decision = this.strategy.getDecision();
        if (this.decision != null) {
            this.decision.setPrevious(tmp);
            this.moveTo(4);
        } else {
            this.decision = tmp;
            this.recordSolution();
        }
    }

    private void recordSolution() {
        this.solver.setFeasible(ESat.TRUE);
        assert (ESat.TRUE.equals((Object)this.solver.isSatisfied())) : Reporting.fullReport(this.solver);
        this.objectivemanager.update();
        if (this.stopAtFirstSolution) {
            this.interrupt("stop at first solution");
        } else {
            this.moveTo(16);
        }
        this.smList.onSolution();
    }

    private void downLeftBranch() {
        this.downBranch();
    }

    private void downRightBranch() {
        this.downBranch();
    }

    private void downBranch() {
        this.env.worldPush();
        try {
            this.decision.buildNext();
            this.objectivemanager.apply(this.decision);
            this.objectivemanager.postDynamicCut();
            this.solver.getEngine().propagate();
            this.moveTo(2);
        }
        catch (ContradictionException e) {
            this.solver.getEngine().flush();
            this.moveTo(16);
            this.jumpTo = 1;
            this.smList.onContradiction(e);
        }
    }

    private void upBranch() {
        this.env.worldPop();
        if (this.decision == RootDecision.ROOT) {
            this.interrupt("the entire search space has been explored");
        } else {
            --this.jumpTo;
            if (this.jumpTo <= 0 && this.decision.hasNext()) {
                this.moveTo(8);
            } else {
                Decision tmp = this.decision;
                this.decision = this.decision.getPrevious();
                tmp.free();
            }
        }
    }

    private void restartSearch() {
        this.restoreRootNode();
        this.solver.getEnvironment().worldPush();
        try {
            this.objectivemanager.postDynamicCut();
            this.solver.getEngine().propagate();
            this.nextState = 2;
        }
        catch (ContradictionException e) {
            this.interrupt("applying the cut leads to a failure");
        }
    }

    private void close() {
        ESat sat = ESat.FALSE;
        if (this.measures.getSolutionCount() > 0L) {
            sat = ESat.TRUE;
            if (this.objectivemanager.isOptimization()) {
                this.measures.setObjectiveOptimal(!this.hasReachedLimit);
            }
        } else if (this.hasReachedLimit) {
            this.measures.setObjectiveOptimal(false);
            sat = ESat.UNDEFINED;
        }
        this.solver.setFeasible(sat);
    }

    @Override
    public void plugSearchMonitor(ISearchMonitor sm) {
        if (!this.smList.contains(sm)) {
            this.smList.add(sm);
        } else {
            LOGGER.debug("The search monitor already exists and is ignored");
        }
    }

    @Override
    public void setObjectiveManager(ObjectiveManager objectivemanager) {
        this.objectivemanager = objectivemanager;
        if (objectivemanager.isOptimization()) {
            this.measures.declareObjective();
        }
    }

    @Override
    public void overridePreviousWorld(int gap) {
        this.jumpTo = gap;
    }

    @Override
    public void set(AbstractStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public final void reachLimit() {
        this.hasReachedLimit = true;
        this.interrupt("a limit has been reached");
    }

    @Override
    public void setLastDecision(Decision d) {
        this.decision = d;
    }

    @Override
    public ObjectiveManager getObjectiveManager() {
        return this.objectivemanager;
    }

    @Override
    public AbstractStrategy<Variable> getStrategy() {
        return this.strategy;
    }

    @Override
    public int getCurrentDepth() {
        int d = 0;
        Decision tmp = this.decision;
        while (tmp != RootDecision.ROOT) {
            tmp = tmp.getPrevious();
            ++d;
        }
        return d;
    }

    @Override
    public boolean hasReachedLimit() {
        return this.hasReachedLimit;
    }

    @Override
    public int getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Decision getLastDecision() {
        return this.decision;
    }

    @Override
    public SearchMonitorList getSMList() {
        return this.smList;
    }
}

