/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.explanations.LazyExplanationEngineFromRestart;
import org.chocosolver.solver.explanations.strategies.ExplainingCut;
import org.chocosolver.solver.explanations.strategies.ExplainingObjective;
import org.chocosolver.solver.explanations.strategies.PGN4Explanation;
import org.chocosolver.solver.explanations.strategies.RPGN4Explanation;
import org.chocosolver.solver.explanations.strategies.RandomNeighborhood4Explanation;
import org.chocosolver.solver.search.limits.ACounter;
import org.chocosolver.solver.search.loop.lns.LargeNeighborhoodSearch;
import org.chocosolver.solver.search.loop.lns.neighbors.AdaptiveNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.lns.neighbors.PropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.RandomNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.ReversePropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.SequenceNeighborhood;
import org.chocosolver.solver.variables.IntVar;

public class LNSFactory {
    public static INeighbor random(Solver solver, IntVar[] vars, int level, long seed, ACounter frcounter) {
        RandomNeighborhood neighbor = new RandomNeighborhood(solver, vars, level, seed);
        neighbor.fastRestart(frcounter);
        return neighbor;
    }

    public static INeighbor pg(Solver solver, IntVar[] vars, int fgmtSize, int listSize, long seed, ACounter frcounter) {
        PropagationGuidedNeighborhood neighbor = new PropagationGuidedNeighborhood(solver, vars, seed, fgmtSize, listSize);
        neighbor.fastRestart(frcounter);
        return neighbor;
    }

    public static INeighbor rpg(Solver solver, IntVar[] vars, int fgmtSize, int listSize, long seed, ACounter frcounter) {
        ReversePropagationGuidedNeighborhood neighbor = new ReversePropagationGuidedNeighborhood(solver, vars, seed, fgmtSize, listSize);
        neighbor.fastRestart(frcounter);
        return neighbor;
    }

    public static LargeNeighborhoodSearch rlns(Solver solver, IntVar[] vars, int level, long seed, ACounter frcounter) {
        INeighbor neighbor = LNSFactory.random(solver, vars, level, seed, frcounter);
        LargeNeighborhoodSearch lns = new LargeNeighborhoodSearch(solver, neighbor, true);
        solver.getSearchLoop().plugSearchMonitor(lns);
        return lns;
    }

    public static LargeNeighborhoodSearch pglns(Solver solver, IntVar[] vars, int fgmtSize, int listSize, int level, long seed, ACounter frcounter) {
        SequenceNeighborhood neighbor = new SequenceNeighborhood(LNSFactory.pg(solver, vars, fgmtSize, listSize, seed, frcounter), LNSFactory.rpg(solver, vars, fgmtSize, listSize, seed, frcounter), LNSFactory.pg(solver, vars, fgmtSize, 0, seed, frcounter));
        LargeNeighborhoodSearch lns = new LargeNeighborhoodSearch(solver, neighbor, true);
        solver.getSearchLoop().plugSearchMonitor(lns);
        return lns;
    }

    public static LargeNeighborhoodSearch elns(Solver solver, IntVar[] vars, int level, long seed, ACounter fr4exp, ACounter fr4rnd) {
        if (!(solver.getExplainer() instanceof LazyExplanationEngineFromRestart)) {
            solver.set(new LazyExplanationEngineFromRestart(solver));
        }
        ExplainingObjective neighbor1 = new ExplainingObjective(solver, level, seed);
        neighbor1.fastRestart(fr4exp);
        ExplainingCut neighbor2 = new ExplainingCut(solver, level, seed);
        neighbor2.fastRestart(fr4exp);
        RandomNeighborhood4Explanation neighbor3 = new RandomNeighborhood4Explanation(solver, vars, level, seed);
        neighbor3.fastRestart(fr4rnd);
        SequenceNeighborhood neighbor = new SequenceNeighborhood(neighbor1, neighbor2, neighbor3);
        LargeNeighborhoodSearch lns = new LargeNeighborhoodSearch(solver, neighbor, true);
        solver.getSearchLoop().plugSearchMonitor(lns);
        return lns;
    }

    public static LargeNeighborhoodSearch pgelns(Solver solver, IntVar[] vars, int level, long seed, int fgmtSize, int listSize, ACounter fr4exp, ACounter fr4rnd) {
        if (!(solver.getExplainer() instanceof LazyExplanationEngineFromRestart)) {
            solver.set(new LazyExplanationEngineFromRestart(solver));
        }
        ExplainingObjective neighbor1 = new ExplainingObjective(solver, level, seed);
        neighbor1.fastRestart(fr4exp);
        PGN4Explanation neighbor2 = new PGN4Explanation(solver, vars, seed, fgmtSize, listSize);
        neighbor2.fastRestart(fr4rnd);
        RPGN4Explanation neighbor3 = new RPGN4Explanation(solver, vars, seed, fgmtSize, listSize);
        neighbor3.fastRestart(fr4rnd);
        ExplainingCut neighbor4 = new ExplainingCut(solver, level, seed);
        neighbor4.fastRestart(fr4exp);
        PGN4Explanation neighbor5 = new PGN4Explanation(solver, vars, seed, fgmtSize, 0);
        neighbor5.fastRestart(fr4rnd);
        SequenceNeighborhood neighbor = new SequenceNeighborhood(neighbor1, neighbor2, neighbor3, neighbor4, neighbor5);
        LargeNeighborhoodSearch lns = new LargeNeighborhoodSearch(solver, neighbor, true);
        solver.getSearchLoop().plugSearchMonitor(lns);
        return lns;
    }

    public static LargeNeighborhoodSearch apgelns(Solver solver, IntVar[] vars, int level, long seed, int fgmtSize, int listSize, ACounter fr4exp, ACounter fr4rnd) {
        if (!(solver.getExplainer() instanceof LazyExplanationEngineFromRestart)) {
            solver.set(new LazyExplanationEngineFromRestart(solver));
        }
        ExplainingObjective neighbor1 = new ExplainingObjective(solver, level, seed);
        neighbor1.fastRestart(fr4exp);
        PGN4Explanation neighbor2 = new PGN4Explanation(solver, vars, seed, fgmtSize, listSize);
        neighbor2.fastRestart(fr4rnd);
        RPGN4Explanation neighbor3 = new RPGN4Explanation(solver, vars, seed, fgmtSize, listSize);
        neighbor3.fastRestart(fr4rnd);
        ExplainingCut neighbor4 = new ExplainingCut(solver, level, seed);
        neighbor4.fastRestart(fr4exp);
        PGN4Explanation neighbor5 = new PGN4Explanation(solver, vars, seed, fgmtSize, 0);
        neighbor5.fastRestart(fr4rnd);
        AdaptiveNeighborhood neighbor = new AdaptiveNeighborhood(seed, neighbor1, neighbor2, neighbor3, neighbor4, neighbor5);
        LargeNeighborhoodSearch lns = new LargeNeighborhoodSearch(solver, neighbor, true);
        solver.getSearchLoop().plugSearchMonitor(lns);
        return lns;
    }
}

