/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.monitors.IMonitorInterruption;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;

public class LargeNeighborhoodSearch
implements ICause,
IMonitorSolution,
IMonitorInterruption,
IMonitorRestart {
    protected Solver solver;
    protected final INeighbor neighbor;
    protected boolean hasAppliedNeighborhood;

    public LargeNeighborhoodSearch(Solver solver, INeighbor neighbor, boolean restartAfterEachSolution) {
        this.solver = solver;
        this.neighbor = neighbor;
        solver.plugMonitor(() -> {
            if (restartAfterEachSolution) {
                solver.getSearchLoop().restart();
            }
        });
    }

    @Override
    public void onSolution() {
        if (this.solver.getMeasures().getSolutionCount() == 1L) {
            this.neighbor.activeFastRestart();
        }
        this.neighbor.recordSolution();
    }

    @Override
    public void afterInterrupt() {
        if (this.hasAppliedNeighborhood && this.solver.getMeasures().getSolutionCount() > 0L && !this.solver.getSearchLoop().hasReachedLimit() && !this.neighbor.isSearchComplete()) {
            this.neighbor.restrictLess();
            this.solver.getSearchLoop().forceAlive(true);
            this.solver.getSearchLoop().restart();
        }
    }

    @Override
    public void beforeRestart() {
        this.hasAppliedNeighborhood = false;
    }

    @Override
    public void afterRestart() {
        if (this.solver.getMeasures().getSolutionCount() > 0L) {
            try {
                this.neighbor.fixSomeVariables(this);
                this.hasAppliedNeighborhood = true;
                this.solver.getEngine().propagate();
            }
            catch (ContradictionException e) {
                this.solver.getEngine().flush();
                this.neighbor.restrictLess();
                this.solver.getSearchLoop().restart();
            }
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
    }
}

