/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.BitSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.ANeighbor;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.variables.IntVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityBasedNeighborhood
extends ANeighbor {
    public static final Logger logger = LoggerFactory.getLogger(ActivityBasedNeighborhood.class);
    private final int n;
    private final IntVar[] vars;
    private final int[] bestSolution;
    private int nbFixedVars;
    private final ActivityBased abs;

    public ActivityBasedNeighborhood(Solver solver, IntVar[] vars, ActivityBased abs, int firstNbFixedVars) {
        super(solver);
        this.n = vars.length;
        this.vars = (IntVar[])vars.clone();
        this.bestSolution = new int[this.n];
        this.abs = abs;
        this.nbFixedVars = firstNbFixedVars;
    }

    @Override
    public void recordSolution() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.bestSolution[i] = this.vars[i].getValue();
        }
    }

    @Override
    public void restrictLess() {
        this.nbFixedVars /= 2;
        if (logger.isDebugEnabled()) {
            this.mSolver.getMeasures().updateTimeCount();
            logger.debug(">> nbFixedVars {}", (Object)this.nbFixedVars);
        }
    }

    @Override
    public boolean isSearchComplete() {
        return this.nbFixedVars == 0;
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        if (!this.abs.sampling) {
            this.activity(cause);
        }
    }

    private void activity(ICause cause) throws ContradictionException {
        BitSet selected = new BitSet(this.vars.length);
        while (selected.cardinality() < this.nbFixedVars) {
            double a = -2.147483648E9;
            int idx = -1;
            for (int k = 0; k < this.nbFixedVars; ++k) {
                double ao = this.abs.getActivity(this.vars[k]);
                if (selected.get(k) || !(ao > a)) continue;
                a = ao;
                idx = k;
            }
            this.vars[idx].instantiateTo(this.bestSolution[idx], cause);
            selected.set(idx);
        }
    }
}

