/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.BitSet;
import java.util.Random;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.ANeighbor;
import org.chocosolver.solver.variables.IntVar;

public class RandomNeighborhood
extends ANeighbor {
    protected final int n;
    protected final IntVar[] vars;
    protected final int[] bestSolution;
    private final int[] previous;
    private Random rd;
    private double nbFixedVariables = 0.0;
    private int nbCall;
    private int limit;
    private int level;
    protected BitSet fragment;

    public RandomNeighborhood(Solver aSolver, IntVar[] vars, int level, long seed) {
        super(aSolver);
        this.n = vars.length;
        this.vars = (IntVar[])vars.clone();
        this.level = level;
        this.rd = new Random(seed);
        this.bestSolution = new int[this.n];
        this.previous = new int[this.n];
        this.fragment = new BitSet(this.n);
    }

    @Override
    public boolean isSearchComplete() {
        return false;
    }

    @Override
    public void recordSolution() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.previous[i] = this.bestSolution[i];
            this.bestSolution[i] = this.vars[i].getValue();
        }
        this.nbFixedVariables = 2.0 * (double)this.n / 3.0 + 1.0;
        this.nbCall = 0;
        this.limit = 200;
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        ++this.nbCall;
        this.restrictLess();
        this.fragment.set(0, this.n);
        int i = 0;
        while ((double)i < this.nbFixedVariables - 1.0 && this.fragment.cardinality() > 0) {
            int id = this.selectVariable();
            if (this.vars[id].contains(this.bestSolution[id])) {
                this.impose(id, cause);
            }
            this.fragment.clear(id);
            ++i;
        }
    }

    protected void impose(int id, ICause cause) throws ContradictionException {
        this.vars[id].instantiateTo(this.bestSolution[id], cause);
    }

    protected int selectVariable() {
        int id = this.fragment.nextSetBit(0);
        for (int cc = this.rd.nextInt(this.fragment.cardinality()); id >= 0 && cc > 0; --cc) {
            id = this.fragment.nextSetBit(id + 1);
        }
        return id;
    }

    @Override
    public void restrictLess() {
        if (this.nbCall > this.limit) {
            this.limit = this.nbCall + this.level;
            this.nbFixedVariables = this.rd.nextDouble() * (double)this.n;
        }
    }
}

