/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.PropagationGuidedNeighborhood;
import org.chocosolver.solver.variables.IntVar;

public class ReversePropagationGuidedNeighborhood
extends PropagationGuidedNeighborhood {
    public ReversePropagationGuidedNeighborhood(Solver solver, IntVar[] vars, long seed, int fgmtSize, int listSize) {
        super(solver, vars, seed, fgmtSize, listSize);
    }

    @Override
    protected void update(ICause cause) throws ContradictionException {
        while (this.logSum > (double)this.fgmtSize && this.fragment.cardinality() > 0) {
            this.all.clear();
            int id = this.selectVariable();
            if (this.vars[id].contains(this.bestSolution[id])) {
                this.mSolver.getEnvironment().worldPush();
                this.vars[id].instantiateTo(this.bestSolution[id], cause);
                this.mSolver.propagate();
                this.fragment.clear(id);
                for (int i = 0; i < this.n; ++i) {
                    int ds = this.vars[i].getDomainSize();
                    if (!this.fragment.get(i)) continue;
                    if (ds == 1) {
                        this.fragment.clear(i);
                        continue;
                    }
                    int closeness = (int)((double)(this.dsize[i] - ds) / ((double)this.dsize[i] * 1.0) * 100.0);
                    if (closeness <= 0) continue;
                    this.all.put(i, Integer.MAX_VALUE - closeness);
                }
                this.mSolver.getEnvironment().worldPop();
                this.candidate.clear();
                int k = 1;
                while (!this.all.isEmpty() && this.candidate.size() < this.listSize) {
                    int first = (Integer)this.all.firstKey();
                    this.all.remove(first);
                    if (!this.fragment.get(first)) continue;
                    this.candidate.put(first, k++);
                }
                this.logSum = 0.0;
                int i = this.fragment.nextSetBit(0);
                while (i > -1 && i < this.n) {
                    this.logSum += Math.log(this.vars[i].getDomainSize());
                    i = this.fragment.nextSetBit(i + 1);
                }
                continue;
            }
            this.fragment.clear(id);
        }
        int i = this.fragment.nextSetBit(0);
        while (i > -1 && i < this.n) {
            if (this.vars[i].contains(this.bestSolution[i])) {
                this.impose(i, cause);
            }
            i = this.fragment.nextSetBit(i + 1);
        }
        this.mSolver.propagate();
        this.logSum = 0.0;
        for (i = 0; i < this.n; ++i) {
            this.logSum += Math.log(this.vars[i].getDomainSize());
        }
    }
}

