/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.limits.ACounter;
import org.chocosolver.solver.search.loop.lns.neighbors.ANeighbor;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;

public class SequenceNeighborhood
extends ANeighbor {
    protected int who;
    protected int count;
    protected INeighbor[] neighbors;
    protected int[] counters;

    public SequenceNeighborhood(INeighbor ... neighbors) {
        super(null);
        this.neighbors = neighbors;
        this.who = 0;
        this.count = neighbors.length;
        this.counters = new int[this.count];
        this.counters[0] = -1;
    }

    @Override
    public void recordSolution() {
        int n = this.who;
        this.counters[n] = this.counters[n] + 1;
        for (int i = 0; i < this.count; ++i) {
            this.neighbors[i].recordSolution();
        }
        this.who = this.count - 1;
    }

    @Override
    public void fixSomeVariables(ICause cause) throws ContradictionException {
        this.nextNeighbor();
        if (this.who == this.count) {
            this.who = 0;
        }
        this.neighbors[this.who].fixSomeVariables(cause);
    }

    @Override
    public void restrictLess() {
        this.neighbors[this.who].restrictLess();
    }

    @Override
    public boolean isSearchComplete() {
        boolean isComplete = false;
        for (int i = 0; i < this.count; ++i) {
            isComplete |= this.neighbors[i].isSearchComplete();
        }
        return isComplete;
    }

    @Override
    public void activeFastRestart() {
        for (int i = 0; i < this.count; ++i) {
            this.neighbors[i].activeFastRestart();
        }
    }

    @Override
    public void fastRestart(ACounter counter) {
        for (int i = 0; i < this.count; ++i) {
            this.neighbors[i].fastRestart(counter);
        }
    }

    protected void nextNeighbor() {
        ++this.who;
    }
}

