/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import gnu.trove.map.hash.TIntIntHashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;

public class FailPerPropagator
implements IMonitorContradiction {
    protected TIntIntHashMap p2w = new TIntIntHashMap();

    public FailPerPropagator(Constraint[] constraints, Solver solver) {
        this.init(constraints);
        solver.plugMonitor(this);
    }

    private void init(Constraint[] constraints) {
        for (int c = 0; c < constraints.length; ++c) {
            Propagator[] propagators = constraints[c].getPropagators();
            for (int p = 0; p < propagators.length; ++p) {
                this.p2w.put(propagators[p].getId(), 0);
            }
        }
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        if (cex.c != null && cex.c instanceof Propagator) {
            this.p2w.adjustOrPutValue(((Propagator)cex.c).getId(), 1, 1);
        }
    }

    public int getFails(Propagator p) {
        return this.p2w.get(p.getId());
    }
}

