/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.restart.IRestartStrategy;

public final class RestartManager
implements IMonitorInitialize,
IMonitorOpenNode,
IMonitorSolution,
IMonitorRestart {
    final IRestartStrategy restartStrategy;
    final ICounter restartStrategyLimit;
    final ISearchLoop searchLoop;
    int restartFromStrategyCount;
    int restartCutoff;
    int restartLimit;

    protected RestartManager(IRestartStrategy restartStrategy, ICounter restartStrategyLimit, ISearchLoop searchLoop, int restartLimit) {
        this.restartStrategy = restartStrategy;
        this.restartStrategyLimit = restartStrategyLimit;
        this.restartLimit = restartLimit;
        this.searchLoop = searchLoop;
        this.searchLoop.plugSearchMonitor(restartStrategyLimit);
    }

    @Override
    public void beforeInitialize() {
    }

    @Override
    public void afterInitialize() {
        this.restartFromStrategyCount = 0;
        this.restartCutoff = this.restartStrategy.getScaleFactor();
        this.restartStrategyLimit.overrideLimit(this.restartCutoff);
    }

    @Override
    public void beforeOpenNode() {
        if (this.restartStrategyLimit.isReached()) {
            ++this.restartFromStrategyCount;
            this.restartCutoff = this.restartStrategy.getNextCutoff(this.restartFromStrategyCount);
            this.restartStrategyLimit.overrideLimit(this.restartStrategyLimit.getLimitValue() + (long)this.restartCutoff);
            this.searchLoop.restart();
        }
    }

    @Override
    public void afterOpenNode() {
    }

    @Override
    public void onSolution() {
        this.restartStrategyLimit.overrideLimit(this.restartStrategyLimit.getLimitValue() + (long)this.restartCutoff);
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        if (this.restartFromStrategyCount >= this.restartLimit) {
            this.restartStrategyLimit.overrideLimit(Long.MAX_VALUE);
        }
    }
}

