/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.limits.ActionCounterFactory;
import org.chocosolver.solver.search.limits.BacktrackCounter;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.limits.NodeCounter;
import org.chocosolver.solver.search.limits.SolutionCounter;
import org.chocosolver.solver.search.limits.ThreadTimeCounter;
import org.chocosolver.solver.search.limits.TimeCounter;
import org.chocosolver.solver.search.loop.monitors.RestartManager;
import org.chocosolver.solver.search.restart.GeometricalRestartStrategy;
import org.chocosolver.solver.search.restart.LubyRestartStrategy;

public class SearchMonitorFactory {
    public static Pattern Dp = Pattern.compile("(\\d+)d");
    public static Pattern Hp = Pattern.compile("(\\d+)h");
    public static Pattern Mp = Pattern.compile("(\\d+)m");
    public static Pattern Sp = Pattern.compile("(\\d+(\\.\\d+)?)s");

    SearchMonitorFactory() {
    }

    public static void luby(Solver solver, int scaleFactor, int geometricalFactor, ICounter restartStrategyLimit, int restartLimit) {
        solver.plugMonitor(new RestartManager(new LubyRestartStrategy(scaleFactor, geometricalFactor), restartStrategyLimit, solver.getSearchLoop(), restartLimit));
    }

    public static void geometrical(Solver solver, int scaleFactor, double geometricalFactor, ICounter restartStrategyLimit, int restartLimit) {
        solver.plugMonitor(new RestartManager(new GeometricalRestartStrategy(scaleFactor, geometricalFactor), restartStrategyLimit, solver.getSearchLoop(), restartLimit));
    }

    public static void limitNode(Solver solver, long limit) {
        NodeCounter counter = new NodeCounter(limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void limitSolution(Solver solver, long limit) {
        SolutionCounter counter = new SolutionCounter(limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void limitTime(Solver solver, long limit) {
        TimeCounter counter = new TimeCounter(solver, limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void limitTime(Solver solver, String duration) {
        SearchMonitorFactory.limitTime(solver, SearchMonitorFactory.convertInMilliseconds(duration));
    }

    public static void limitThreadTime(Solver solver, long limit) {
        ThreadTimeCounter counter = new ThreadTimeCounter(limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void limitThreadTime(Solver solver, String duration) {
        SearchMonitorFactory.limitThreadTime(solver, SearchMonitorFactory.convertInMilliseconds(duration));
    }

    public static long convertInMilliseconds(String duration) {
        long milliseconds = 0L;
        Matcher matcher = Dp.matcher(duration = duration.replaceAll("\\s+", ""));
        if (matcher.find() && matcher.groupCount() == 1) {
            int days = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
        }
        if ((matcher = Hp.matcher(duration)).find() && matcher.groupCount() == 1) {
            int hours = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS);
        }
        if ((matcher = Mp.matcher(duration)).find() && matcher.groupCount() == 1) {
            int minutes = Integer.parseInt(matcher.group(1));
            milliseconds += TimeUnit.MILLISECONDS.convert(minutes, TimeUnit.MINUTES);
        }
        if ((matcher = Sp.matcher(duration)).find() && matcher.groupCount() == 2) {
            double seconds = Double.parseDouble(matcher.group(1));
            milliseconds += (long)((int)(seconds * 1000.0));
        }
        if (milliseconds == 0L) {
            throw new SolverException("Duration cannot be parsed or must be positive" + duration);
        }
        return milliseconds;
    }

    public static void limitFail(Solver solver, long limit) {
        FailCounter counter = new FailCounter(limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void limitBacktrack(Solver solver, long limit) {
        BacktrackCounter counter = new BacktrackCounter(limit);
        counter.setAction(ActionCounterFactory.interruptSearch(solver.getSearchLoop()));
        solver.plugMonitor(counter);
    }

    public static void restartAfterEachSolution(Solver solver) {
        solver.plugMonitor(() -> solver.getSearchLoop().restart());
    }
}

