/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitPropagation;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorInterruption;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;

public final class SearchMonitorList
implements IMonitorClose,
IMonitorContradiction,
IMonitorDownBranch,
IMonitorInitialize,
IMonitorInitPropagation,
IMonitorInterruption,
IMonitorOpenNode,
IMonitorRestart,
IMonitorSolution,
IMonitorUpBranch {
    List<IMonitorClose> mclos = new ArrayList<IMonitorClose>();
    List<IMonitorContradiction> mcont = new ArrayList<IMonitorContradiction>();
    List<IMonitorDownBranch> mdbra = new ArrayList<IMonitorDownBranch>();
    List<IMonitorInitialize> minit = new ArrayList<IMonitorInitialize>();
    List<IMonitorInitPropagation> mipro = new ArrayList<IMonitorInitPropagation>();
    List<IMonitorInterruption> minte = new ArrayList<IMonitorInterruption>();
    List<IMonitorOpenNode> mopno = new ArrayList<IMonitorOpenNode>();
    List<IMonitorRestart> mrest = new ArrayList<IMonitorRestart>();
    List<IMonitorSolution> msolu = new ArrayList<IMonitorSolution>();
    List<IMonitorUpBranch> mubra = new ArrayList<IMonitorUpBranch>();

    @Override
    public void beforeInitialize() {
        for (int i = 0; i < this.minit.size(); ++i) {
            this.minit.get(i).beforeInitialize();
        }
    }

    @Override
    public void afterInitialize() {
        for (int i = 0; i < this.minit.size(); ++i) {
            this.minit.get(i).afterInitialize();
        }
    }

    @Override
    public void beforeInitialPropagation() {
        for (int i = 0; i < this.mipro.size(); ++i) {
            this.mipro.get(i).beforeInitialPropagation();
        }
    }

    @Override
    public void afterInitialPropagation() {
        for (int i = 0; i < this.mipro.size(); ++i) {
            this.mipro.get(i).afterInitialPropagation();
        }
    }

    @Override
    public void beforeOpenNode() {
        for (int i = 0; i < this.mopno.size(); ++i) {
            this.mopno.get(i).beforeOpenNode();
        }
    }

    @Override
    public void afterOpenNode() {
        for (int i = 0; i < this.mopno.size(); ++i) {
            this.mopno.get(i).afterOpenNode();
        }
    }

    @Override
    public void onSolution() {
        for (int i = 0; i < this.msolu.size(); ++i) {
            this.msolu.get(i).onSolution();
        }
    }

    @Override
    public void beforeDownLeftBranch() {
        for (int i = 0; i < this.mdbra.size(); ++i) {
            this.mdbra.get(i).beforeDownLeftBranch();
        }
    }

    @Override
    public void afterDownLeftBranch() {
        for (int i = 0; i < this.mdbra.size(); ++i) {
            this.mdbra.get(i).afterDownLeftBranch();
        }
    }

    @Override
    public void beforeDownRightBranch() {
        for (int i = 0; i < this.mdbra.size(); ++i) {
            this.mdbra.get(i).beforeDownRightBranch();
        }
    }

    @Override
    public void afterDownRightBranch() {
        for (int i = 0; i < this.mdbra.size(); ++i) {
            this.mdbra.get(i).afterDownRightBranch();
        }
    }

    @Override
    public void beforeUpBranch() {
        for (int i = 0; i < this.mubra.size(); ++i) {
            this.mubra.get(i).beforeUpBranch();
        }
    }

    @Override
    public void afterUpBranch() {
        for (int i = 0; i < this.mubra.size(); ++i) {
            this.mubra.get(i).afterUpBranch();
        }
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        for (int i = 0; i < this.mcont.size(); ++i) {
            this.mcont.get(i).onContradiction(cex);
        }
    }

    @Override
    public void beforeRestart() {
        for (int i = 0; i < this.mrest.size(); ++i) {
            this.mrest.get(i).beforeRestart();
        }
    }

    @Override
    public void afterRestart() {
        for (int i = 0; i < this.mrest.size(); ++i) {
            this.mrest.get(i).afterRestart();
        }
    }

    @Override
    public void afterInterrupt() {
        for (int i = 0; i < this.minte.size(); ++i) {
            this.minte.get(i).afterInterrupt();
        }
    }

    @Override
    public void beforeClose() {
        for (int i = 0; i < this.mclos.size(); ++i) {
            this.mclos.get(i).beforeClose();
        }
    }

    @Override
    public void afterClose() {
        for (int i = 0; i < this.mclos.size(); ++i) {
            this.mclos.get(i).afterClose();
        }
    }

    public void add(ISearchMonitor sm) {
        if (sm != null) {
            if (sm instanceof IMonitorClose) {
                this.mclos.add((IMonitorClose)sm);
            }
            if (sm instanceof IMonitorContradiction) {
                this.mcont.add((IMonitorContradiction)sm);
            }
            if (sm instanceof IMonitorDownBranch) {
                this.mdbra.add((IMonitorDownBranch)sm);
            }
            if (sm instanceof IMonitorInitialize) {
                this.minit.add((IMonitorInitialize)sm);
            }
            if (sm instanceof IMonitorInitPropagation) {
                this.mipro.add((IMonitorInitPropagation)sm);
            }
            if (sm instanceof IMonitorInterruption) {
                this.minte.add((IMonitorInterruption)sm);
            }
            if (sm instanceof IMonitorOpenNode) {
                this.mopno.add((IMonitorOpenNode)sm);
            }
            if (sm instanceof IMonitorRestart) {
                this.mrest.add((IMonitorRestart)sm);
            }
            if (sm instanceof IMonitorSolution) {
                this.msolu.add((IMonitorSolution)sm);
            }
            if (sm instanceof IMonitorUpBranch) {
                this.mubra.add((IMonitorUpBranch)sm);
            }
        }
    }

    public boolean contains(ISearchMonitor sm) {
        boolean isPluggedIn = false;
        if (sm != null) {
            if (sm instanceof IMonitorClose) {
                isPluggedIn = this.mclos.contains(sm);
            }
            if (sm instanceof IMonitorContradiction) {
                isPluggedIn = this.mcont.contains(sm);
            }
            if (sm instanceof IMonitorDownBranch) {
                isPluggedIn = this.mdbra.contains(sm);
            }
            if (sm instanceof IMonitorInitialize) {
                isPluggedIn = this.minit.contains(sm);
            }
            if (sm instanceof IMonitorInitPropagation) {
                isPluggedIn = this.mipro.contains(sm);
            }
            if (sm instanceof IMonitorInterruption) {
                isPluggedIn = this.minte.contains(sm);
            }
            if (sm instanceof IMonitorOpenNode) {
                isPluggedIn = this.mopno.contains(sm);
            }
            if (sm instanceof IMonitorRestart) {
                isPluggedIn = this.mrest.contains(sm);
            }
            if (sm instanceof IMonitorSolution) {
                isPluggedIn = this.msolu.contains(sm);
            }
            if (sm instanceof IMonitorUpBranch) {
                isPluggedIn = this.mubra.contains(sm);
            }
        }
        return isPluggedIn;
    }

    public void reset() {
        this.mclos.clear();
        this.mcont.clear();
        this.mdbra.clear();
        this.minit.clear();
        this.minte.clear();
        this.mipro.clear();
        this.mopno.clear();
        this.mrest.clear();
        this.msolu.clear();
        this.mubra.clear();
    }
}

