/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.measure;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitPropagation;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.search.loop.monitors.IMonitorOpenNode;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.measure.IMeasures;

public final class MeasuresRecorder
implements IMeasures,
IMonitorClose,
IMonitorContradiction,
IMonitorDownBranch,
IMonitorInitialize,
IMonitorInitPropagation,
IMonitorOpenNode,
IMonitorRestart,
IMonitorSolution,
IMonitorUpBranch {
    private static final float IN_SEC = 1.0E9f;
    public boolean hasObjective;
    public boolean objectiveOptimal;
    public long solutionCount;
    public long timeCount;
    public long readingTimeCount;
    public long initialisationTimeCount;
    public long initialPropagationTimeCount;
    public long nodeCount;
    public long backtrackCount;
    public long failCount;
    public long restartCount;
    public long maxDepth;
    public long depth;
    public long propagationCount;
    public long eventCount;
    public long usedMemory;
    protected long startingTime;
    protected long startingMemory;
    protected Solver solver;
    protected Constraint[] cstrs;

    public MeasuresRecorder(Solver solver) {
        this.solver = solver;
    }

    @Override
    public MeasuresRecorder duplicate() {
        MeasuresRecorder mr = new MeasuresRecorder(this.solver);
        mr.hasObjective = this.hasObjective;
        mr.objectiveOptimal = this.objectiveOptimal;
        mr.solutionCount = this.solutionCount;
        mr.timeCount = this.timeCount;
        mr.readingTimeCount = this.readingTimeCount;
        mr.initialisationTimeCount = this.initialisationTimeCount;
        mr.initialPropagationTimeCount = this.initialPropagationTimeCount;
        mr.nodeCount = this.nodeCount;
        mr.backtrackCount = this.backtrackCount;
        mr.failCount = this.failCount;
        mr.restartCount = this.restartCount;
        mr.maxDepth = this.maxDepth;
        mr.depth = this.depth;
        mr.propagationCount = this.propagationCount;
        mr.eventCount = this.eventCount;
        mr.usedMemory = this.usedMemory;
        mr.startingTime = this.startingTime;
        mr.startingMemory = this.startingMemory;
        mr.cstrs = (Constraint[])this.cstrs.clone();
        return mr;
    }

    @Override
    public long getSolutionCount() {
        return this.solutionCount;
    }

    @Override
    public void declareObjective() {
        this.hasObjective = true;
    }

    @Override
    public void setObjectiveOptimal(boolean objectiveOptimal) {
        this.objectiveOptimal = objectiveOptimal;
    }

    @Override
    public final void reset() {
        this.timeCount = 0L;
        this.nodeCount = 0L;
        this.backtrackCount = 0L;
        this.restartCount = 0L;
        this.failCount = 0L;
        this.solutionCount = 0L;
        this.hasObjective = false;
        this.readingTimeCount = 0L;
        this.initialisationTimeCount = 0L;
        this.initialPropagationTimeCount = 0L;
        this.propagationCount = 0L;
        this.eventCount = 0L;
        this.maxDepth = 0L;
        this.cstrs = null;
    }

    @Override
    public long getBackTrackCount() {
        return this.backtrackCount;
    }

    @Override
    public long getFailCount() {
        return this.failCount;
    }

    @Override
    public long getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public float getTimeCount() {
        return (float)this.timeCount / 1.0E9f;
    }

    @Override
    public float getReadingTimeCount() {
        return (float)this.readingTimeCount / 1.0E9f;
    }

    @Override
    public void setReadingTimeCount(long time) {
        this.readingTimeCount = time;
    }

    @Override
    public float getInitialisationTimeCount() {
        return (float)this.initialisationTimeCount / 1.0E9f;
    }

    @Override
    public float getInitialPropagationTimeCount() {
        return (float)this.initialPropagationTimeCount / 1.0E9f;
    }

    @Override
    public long getRestartCount() {
        return this.restartCount;
    }

    @Override
    public long getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public long getCurrentDepth() {
        return this.depth;
    }

    @Override
    public long getPropagationsCount() {
        return this.propagationCount;
    }

    @Override
    public long getEventsCount() {
        return this.eventCount;
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.objectiveOptimal;
    }

    @Override
    public boolean hasObjective() {
        return this.hasObjective;
    }

    @Override
    public Number getBestSolutionValue() {
        return this.solver.getObjectiveManager().getBestSolutionValue();
    }

    @Override
    public long getUsedMemory() {
        return this.usedMemory;
    }

    static long memoryUsedInMB() {
        return Runtime.getRuntime().freeMemory() / 1024L / 1024L;
    }

    @Override
    public void updateMemoryUsed() {
        this.usedMemory = MeasuresRecorder.memoryUsedInMB() - this.startingMemory;
    }

    @Override
    public void updatePropagationCount() {
        if (this.cstrs == null || this.cstrs.length != this.solver.getNbCstrs()) {
            this.cstrs = this.solver.getCstrs();
        }
        this.propagationCount = 0L;
        this.eventCount = 0L;
        for (int i = 0; i < this.cstrs.length; ++i) {
            Propagator[] propagators = this.cstrs[i].getPropagators();
            for (int j = 0; j < propagators.length; ++j) {
                this.propagationCount += propagators[j].coarseERcalls;
                this.eventCount += propagators[j].fineERcalls;
            }
        }
    }

    @Override
    public void updateTimeCount() {
        this.timeCount = System.nanoTime() - this.startingTime;
    }

    @Override
    public long timestamp() {
        return this.nodeCount + this.backtrackCount;
    }

    @Override
    public void beforeInitialize() {
        this.startingMemory = MeasuresRecorder.memoryUsedInMB();
        this.startingTime = System.nanoTime();
    }

    @Override
    public void afterInitialize() {
        this.initialisationTimeCount = System.nanoTime() - this.startingTime;
    }

    @Override
    public void beforeInitialPropagation() {
    }

    @Override
    public void afterInitialPropagation() {
        this.initialPropagationTimeCount = System.nanoTime() - this.startingTime;
    }

    @Override
    public void beforeOpenNode() {
        ++this.nodeCount;
        if (this.depth > this.maxDepth) {
            this.maxDepth = this.depth;
        }
    }

    @Override
    public void afterOpenNode() {
    }

    @Override
    public void onSolution() {
        ++this.solutionCount;
        this.updateTimeCount();
    }

    @Override
    public void beforeDownLeftBranch() {
        ++this.depth;
    }

    @Override
    public void afterDownLeftBranch() {
    }

    @Override
    public void beforeDownRightBranch() {
        ++this.depth;
    }

    @Override
    public void afterDownRightBranch() {
    }

    @Override
    public void beforeUpBranch() {
        ++this.backtrackCount;
        --this.depth;
    }

    @Override
    public void afterUpBranch() {
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        ++this.failCount;
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        ++this.restartCount;
        this.depth = 0L;
    }

    @Override
    public void beforeClose() {
        this.updateTimeCount();
        this.updateMemoryUsed();
        this.updatePropagationCount();
    }

    @Override
    public void afterClose() {
    }

    @Override
    public Number[] toArray() {
        return new Number[]{this.getSolutionCount(), Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getInitialisationTimeCount()), Float.valueOf(this.getInitialPropagationTimeCount()), Float.valueOf(this.getTimeCount()), this.hasObjective() ? (Number)this.getBestSolutionValue() : (Number)0, this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getEventsCount(), this.getPropagationsCount()};
    }

    @Override
    public String toOneLineString() {
        StringBuilder st = new StringBuilder(256);
        st.append(String.format("%d Solutions, ", this.solutionCount));
        if (this.hasObjective()) {
            st.append(this.solver.getObjectiveManager()).append(", ");
        }
        st.append(String.format("Building time : %.3fs, Initialisation : %.3fs, Initial propagation : %.3fs, Total %.3fs, %d Nodes, %d Backtracks, %d Fails, %d Restarts, %d + %d Propagations", Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getInitialisationTimeCount()), Float.valueOf(this.getInitialPropagationTimeCount()), Float.valueOf(this.getTimeCount()), this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getEventsCount(), this.getPropagationsCount()));
        return st.toString();
    }

    @Override
    public String toOneShortLineString() {
        StringBuilder st = new StringBuilder(256);
        st.append(String.format("%d Solutions, ", this.solutionCount));
        if (this.hasObjective()) {
            st.append(this.solver.getObjectiveManager()).append(", ");
        }
        st.append(String.format("Resolution %.3fs, %d Nodes, %d Backtracks, %d Fails, %d Restarts", Float.valueOf(this.getTimeCount()), this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount()));
        return st.toString();
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder(256);
        if (this.solver.hasReachedLimit()) {
            st.append("- Incomplete search - Limit reached.\n");
        } else {
            st.append("- Complete search - ");
            if (this.solutionCount == 0L) {
                st.append("No solution.");
            }
            st.append('\n');
        }
        st.append(String.format("\tSolutions: %,d\n", this.solutionCount));
        if (this.hasObjective()) {
            st.append("\t").append(this.solver.getObjectiveManager()).append(",\n");
        }
        st.append(String.format("\tBuilding time : %,.3fs\n\tInitialisation : %,.3fs\n\tInitial propagation : %,.3fs\n\tResolution : %,.3fs\n\tNodes: %,d\n\tBacktracks: %,d\n\tFails: %,d\n\tRestarts: %,d\n\tMax depth: %,d\n\tPropagations: %,d + %,d\n\tMemory: %,dmb\n\tVariables: %,d\n\tConstraints: %,d", Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getInitialisationTimeCount()), Float.valueOf(this.getInitialPropagationTimeCount()), Float.valueOf(this.getTimeCount()), this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getMaxDepth(), this.getEventsCount(), this.getPropagationsCount(), this.getUsedMemory(), this.solver.getNbVars(), this.solver.getNbCstrs()));
        return st.toString();
    }

    @Override
    public String toCSV() {
        return String.format("%d;%.3f;%.3f;%.3f;%.3f;%e;%d;%d;%d;%d;%d;%d;", this.getSolutionCount(), Float.valueOf(this.getReadingTimeCount()), Float.valueOf(this.getInitialisationTimeCount()), Float.valueOf(this.getInitialPropagationTimeCount()), Float.valueOf(this.getTimeCount()), this.hasObjective() ? this.getBestSolutionValue().doubleValue() : 0.0, this.getNodeCount(), this.getBackTrackCount(), this.getFailCount(), this.getRestartCount(), this.getEventsCount(), this.getPropagationsCount());
    }
}

