/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.restart;

import org.chocosolver.solver.search.restart.AbstractRestartStrategy;
import org.chocosolver.util.tools.MathUtils;

public class LubyRestartStrategy
extends AbstractRestartStrategy {
    private int geometricalIntFactor;
    private int divFactor;

    public LubyRestartStrategy(int scaleFactor, int geometricalFactor) {
        super("LUBY", scaleFactor, geometricalFactor);
    }

    @Override
    public final void setGeometricalFactor(double geometricalFactor) {
        LubyRestartStrategy.checkPositiveValue(geometricalFactor);
        double f = Math.floor(geometricalFactor);
        if (f != geometricalFactor) {
            throw new IllegalArgumentException("Luby geometrical parameter should be an integer");
        }
        super.setGeometricalFactor(geometricalFactor);
        this.geometricalIntFactor = (int)geometricalFactor;
        this.divFactor = this.geometricalIntFactor - 1;
    }

    static int geometricalSum(int value, int exponent) {
        return (MathUtils.pow(value, exponent) - 1) / (value - 1);
    }

    int getLasVegasCoef(int i) {
        int k;
        double log = MathUtils.roundedLog(i * this.divFactor + 1, this.geometricalIntFactor);
        if (log == (double)(k = (int)Math.floor(log))) {
            return MathUtils.pow(this.geometricalIntFactor, k - 1);
        }
        return this.getLasVegasCoef(i - LubyRestartStrategy.geometricalSum(this.geometricalIntFactor, k));
    }

    @Override
    public int getNextCutoff(int nbRestarts) {
        return this.getLasVegasCoef(nbRestarts + 1) * this.scaleFactor;
    }
}

