/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.solution;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.solution.AllSolutionsRecorder;
import org.chocosolver.solver.search.solution.Solution;
import org.chocosolver.solver.variables.IntVar;

public class BestSolutionsRecorder
extends AllSolutionsRecorder {
    IntVar objective;
    int lastValue;

    public BestSolutionsRecorder(IntVar objective) {
        super(objective.getSolver());
        this.objective = objective;
        this.solver.plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                Solution last = BestSolutionsRecorder.this.getLastSolution();
                if (last != null) {
                    try {
                        BestSolutionsRecorder.this.solver.getSearchLoop().restoreRootNode();
                        BestSolutionsRecorder.this.solver.getEnvironment().worldPush();
                        last.restore();
                    }
                    catch (ContradictionException e) {
                        throw new UnsupportedOperationException("restoring the last solution ended in a failure");
                    }
                    BestSolutionsRecorder.this.solver.getEngine().flush();
                }
            }

            @Override
            public void afterClose() {
            }
        });
    }

    @Override
    protected IMonitorSolution createRecMonitor() {
        return () -> {
            if (this.objective.getValue() != this.lastValue) {
                this.lastValue = this.objective.getValue();
                this.solutions.clear();
            }
            Solution solution = new Solution();
            solution.record(this.solver);
            this.solutions.add(solution);
        };
    }
}

