/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.solution;

import java.util.LinkedList;
import java.util.List;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.solution.ISolutionRecorder;
import org.chocosolver.solver.search.solution.Solution;

public class LastSolutionRecorder
implements ISolutionRecorder {
    Solution solution;
    Solver solver;
    boolean restoreOnClose;

    public LastSolutionRecorder(final Solution solution, boolean restoreOnClose, final Solver solver) {
        this.solver = solver;
        this.solution = solution;
        this.restoreOnClose = restoreOnClose;
        solver.plugMonitor(() -> solution.record(solver));
        if (restoreOnClose) {
            solver.plugMonitor(new IMonitorClose(){

                @Override
                public void beforeClose() {
                    if (solution.hasBeenFound()) {
                        try {
                            solver.getSearchLoop().restoreRootNode();
                            solver.getEnvironment().worldPush();
                            solution.restore();
                        }
                        catch (ContradictionException e) {
                            throw new UnsupportedOperationException("restoring the last solution ended in a failure");
                        }
                        solver.getEngine().flush();
                    }
                }

                @Override
                public void afterClose() {
                }
            });
        }
    }

    @Override
    public Solution getLastSolution() {
        return this.solution.hasBeenFound() ? this.solution : null;
    }

    @Override
    public List<Solution> getSolutions() {
        LinkedList<Solution> l = new LinkedList<Solution>();
        if (this.solution.hasBeenFound()) {
            l.add(this.solution);
        }
        return l;
    }
}

