/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.solution;

import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.LCF;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.solution.AllSolutionsRecorder;
import org.chocosolver.solver.search.solution.Solution;
import org.chocosolver.solver.variables.IntVar;

public class ParetoSolutionsRecorder
extends AllSolutionsRecorder {
    ResolutionPolicy policy;
    IntVar[] objectives;
    int n;

    public ParetoSolutionsRecorder(ResolutionPolicy policy, IntVar[] objectives) {
        super(objectives[0].getSolver());
        this.objectives = objectives;
        this.n = objectives.length;
        this.policy = policy;
        this.solver.plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                Solution last = ParetoSolutionsRecorder.this.getLastSolution();
                if (last != null) {
                    try {
                        ParetoSolutionsRecorder.this.solver.getSearchLoop().restoreRootNode();
                        ParetoSolutionsRecorder.this.solver.getEnvironment().worldPush();
                        last.restore();
                    }
                    catch (ContradictionException e) {
                        throw new UnsupportedOperationException("restoring the last solution ended in a failure");
                    }
                    ParetoSolutionsRecorder.this.solver.getEngine().flush();
                }
            }

            @Override
            public void afterClose() {
            }
        });
    }

    @Override
    protected IMonitorSolution createRecMonitor() {
        return () -> {
            int i;
            int[] vals = new int[this.n];
            for (i = 0; i < this.n; ++i) {
                vals[i] = this.objectives[i].getValue();
            }
            for (i = this.solutions.size() - 1; i >= 0; --i) {
                if (!this.dominatedSolution((Solution)this.solutions.get(i), vals)) continue;
                this.solutions.remove(i);
            }
            Solution solution = new Solution();
            solution.record(this.solver);
            this.solutions.add(solution);
            Constraint[] better = new Constraint[this.n];
            Operator symbol = Operator.GT;
            if (this.policy == ResolutionPolicy.MINIMIZE) {
                symbol = Operator.LT;
            }
            for (int i2 = 0; i2 < this.n; ++i2) {
                better[i2] = ICF.arithm(this.objectives[i2], symbol.toString(), vals[i2]);
            }
            this.solver.post(LCF.or(better));
        };
    }

    private boolean dominatedSolution(Solution solution, int[] vals) {
        for (int i = 0; i < this.n; ++i) {
            int delta = solution.getIntVal(this.objectives[i]) - vals[i];
            if ((delta <= 0 || this.policy != ResolutionPolicy.MAXIMIZE) && (delta >= 0 || this.policy != ResolutionPolicy.MINIMIZE)) continue;
            return false;
        }
        return true;
    }
}

