/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.solution;

import java.util.Arrays;
import java.util.HashMap;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Solution
implements ICause {
    HashMap<IntVar, Integer> intmap = new HashMap();
    HashMap<RealVar, double[]> realmap = new HashMap();
    HashMap<SetVar, int[]> setmap = new HashMap();
    boolean empty = true;

    public void record(Solver solver) {
        this.empty = false;
        this.intmap.clear();
        this.realmap.clear();
        this.setmap.clear();
        Variable[] vars = solver.getVars();
        block5: for (int i = 0; i < vars.length; ++i) {
            int kind = vars[i].getTypeAndKind() & 0xF8;
            assert (vars[i].isInstantiated()) : vars[i] + " is not instantiated when recording a solution.";
            switch (kind) {
                case 8: 
                case 24: {
                    IntVar v = (IntVar)vars[i];
                    this.intmap.put(v, v.getValue());
                    continue block5;
                }
                case 128: {
                    RealVar r = (RealVar)vars[i];
                    this.realmap.put(r, new double[]{r.getLB(), r.getUB()});
                    continue block5;
                }
                case 64: {
                    SetVar s = (SetVar)vars[i];
                    this.setmap.put(s, s.getValues());
                }
            }
        }
    }

    public void restore() throws ContradictionException {
        if (this.empty) {
            throw new UnsupportedOperationException("Empty solution. No solution found");
        }
        for (IntVar i : this.intmap.keySet()) {
            i.instantiateTo(this.intmap.get(i), this);
        }
        for (SetVar s : this.setmap.keySet()) {
            s.instantiateTo(this.setmap.get(s), this);
        }
        for (RealVar r : this.realmap.keySet()) {
            double[] bounds = this.realmap.get(r);
            r.updateBounds(bounds[0], bounds[1], this);
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        e.add(Explanation.SYSTEM.get());
    }

    public String toString() {
        StringBuilder st = new StringBuilder("Solution: ");
        for (IntVar i : this.intmap.keySet()) {
            st.append(i.getName()).append("=").append(this.intmap.get(i)).append(", ");
        }
        for (SetVar s : this.setmap.keySet()) {
            st.append(s.getName()).append("=").append(Arrays.toString(this.setmap.get(s))).append(", ");
        }
        for (RealVar r : this.realmap.keySet()) {
            double[] bounds = this.realmap.get(r);
            st.append(r.getName()).append("=[").append(bounds[0]).append(",").append(bounds[1]).append("], ");
        }
        return st.toString();
    }

    public int getIntVal(IntVar v) {
        if (this.empty) {
            throw new UnsupportedOperationException("Empty solution. No solution found");
        }
        return this.intmap.get(v);
    }

    public int[] getSetVal(SetVar s) {
        if (this.empty) {
            throw new UnsupportedOperationException("Empty solution. No solution found");
        }
        return this.setmap.get(s);
    }

    public double[] getRealBounds(RealVar r) {
        if (this.empty) {
            throw new UnsupportedOperationException("Empty solution. No solution found");
        }
        return this.realmap.get(r);
    }

    public boolean hasBeenFound() {
        return !this.empty;
    }
}

