/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.selectors.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandomBound;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.AntiFirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDeg;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.ImpactBased;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.MaxRegret;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.GenerateAndTest;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.LastConflict;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.IntVar;

public class IntStrategyFactory {
    IntStrategyFactory() {
    }

    public static VariableSelector<IntVar> lexico_var_selector() {
        return new InputOrder<IntVar>();
    }

    public static VariableSelector<IntVar> random_var_selector(long SEED) {
        return new Random<IntVar>(SEED);
    }

    public static VariableSelector<IntVar> minDomainSize_var_selector() {
        return new FirstFail();
    }

    public static VariableSelector<IntVar> maxDomainSize_var_selector() {
        return new AntiFirstFail();
    }

    public static VariableSelector<IntVar> maxRegret_var_selector() {
        return new MaxRegret();
    }

    public static IntValueSelector min_value_selector() {
        return new IntDomainMin();
    }

    public static IntValueSelector mid_value_selector() {
        return new IntDomainMiddle();
    }

    public static IntValueSelector max_value_selector() {
        return new IntDomainMax();
    }

    public static IntValueSelector randomBound_value_selector(long SEED) {
        return new IntDomainRandomBound(SEED);
    }

    public static IntValueSelector random_value_selector(long SEED) {
        return new IntDomainRandom(SEED);
    }

    public static DecisionOperator<IntVar> assign() {
        return DecisionOperator.int_eq;
    }

    public static DecisionOperator<IntVar> remove() {
        return DecisionOperator.int_neq;
    }

    public static DecisionOperator<IntVar> split() {
        return DecisionOperator.int_split;
    }

    public static DecisionOperator<IntVar> reverse_split() {
        return DecisionOperator.int_reverse_split;
    }

    public static IntStrategy custom(VariableSelector<IntVar> VAR_SELECTOR, IntValueSelector VAL_SELECTOR, DecisionOperator<IntVar> DEC_OPERATOR, IntVar ... VARS) {
        return new IntStrategy(VARS, VAR_SELECTOR, VAL_SELECTOR, DEC_OPERATOR);
    }

    public static IntStrategy custom(VariableSelector<IntVar> VAR_SELECTOR, IntValueSelector VAL_SELECTOR, IntVar ... VARS) {
        return IntStrategyFactory.custom(VAR_SELECTOR, VAL_SELECTOR, IntStrategyFactory.assign(), VARS);
    }

    public static IntStrategy lexico_LB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.lexico_var_selector(), IntStrategyFactory.min_value_selector(), VARS);
    }

    public static IntStrategy lexico_Neq_LB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.lexico_var_selector(), IntStrategyFactory.min_value_selector(), IntStrategyFactory.remove(), VARS);
    }

    public static IntStrategy lexico_Split(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.lexico_var_selector(), IntStrategyFactory.mid_value_selector(), IntStrategyFactory.split(), VARS);
    }

    public static IntStrategy lexico_UB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.lexico_var_selector(), IntStrategyFactory.max_value_selector(), VARS);
    }

    public static IntStrategy minDom_LB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.minDomainSize_var_selector(), IntStrategyFactory.min_value_selector(), VARS);
    }

    public static IntStrategy minDom_MidValue(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.minDomainSize_var_selector(), IntStrategyFactory.mid_value_selector(), VARS);
    }

    public static IntStrategy maxDom_Split(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.maxDomainSize_var_selector(), IntStrategyFactory.mid_value_selector(), IntStrategyFactory.split(), VARS);
    }

    public static IntStrategy minDom_UB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.minDomainSize_var_selector(), IntStrategyFactory.max_value_selector(), VARS);
    }

    public static IntStrategy maxReg_LB(IntVar ... VARS) {
        return IntStrategyFactory.custom(IntStrategyFactory.maxRegret_var_selector(), IntStrategyFactory.min_value_selector(), VARS);
    }

    public static IntStrategy random_bound(IntVar[] VARS, long SEED) {
        return IntStrategyFactory.custom(IntStrategyFactory.random_var_selector(SEED), IntStrategyFactory.randomBound_value_selector(SEED), VARS);
    }

    public static IntStrategy random_bound(IntVar[] VARS) {
        return IntStrategyFactory.random_bound(VARS, 0L);
    }

    public static IntStrategy random_value(IntVar[] VARS, long SEED) {
        return IntStrategyFactory.custom(IntStrategyFactory.random_var_selector(SEED), IntStrategyFactory.random_value_selector(SEED), VARS);
    }

    public static IntStrategy random_value(IntVar[] VARS) {
        return IntStrategyFactory.random_value(VARS, 0L);
    }

    public static AbstractStrategy sequencer(AbstractStrategy ... strategies) {
        return new StrategiesSequencer(strategies);
    }

    public static AbstractStrategy<IntVar> domOverWDeg(IntVar[] VARS, long SEED, IntValueSelector VAL_SELECTOR) {
        return new DomOverWDeg(VARS, SEED, VAL_SELECTOR);
    }

    public static AbstractStrategy<IntVar> domOverWDeg(IntVar[] VARS, long SEED) {
        return IntStrategyFactory.domOverWDeg(VARS, SEED, IntStrategyFactory.min_value_selector());
    }

    public static AbstractStrategy<IntVar> activity(IntVar[] VARS, double GAMMA, double DELTA, int ALPHA, double RESTART, int FORCE_SAMPLING, long SEED) {
        return new ActivityBased(VARS[0].getSolver(), VARS, GAMMA, DELTA, ALPHA, RESTART, FORCE_SAMPLING, SEED);
    }

    public static AbstractStrategy<IntVar> activity(IntVar[] VARS, long SEED) {
        return IntStrategyFactory.activity(VARS, 0.999, 0.2, 8, 1.1, 1, SEED);
    }

    public static AbstractStrategy<IntVar> impact(IntVar[] VARS, int ALPHA, int SPLIT, int NODEIMPACT, long SEED, boolean INITONLY) {
        return new ImpactBased(VARS, ALPHA, SPLIT, NODEIMPACT, SEED, INITONLY);
    }

    public static AbstractStrategy<IntVar> impact(IntVar[] VARS, long SEED) {
        return IntStrategyFactory.impact(VARS, 2, 3, 10, SEED, true);
    }

    public static AbstractStrategy lastConflict(Solver SOLVER) {
        return IntStrategyFactory.lastConflict(SOLVER, SOLVER.getStrategy());
    }

    public static AbstractStrategy lastConflict(Solver SOLVER, AbstractStrategy STRAT) {
        return IntStrategyFactory.lastKConflicts(SOLVER, 1, STRAT);
    }

    public static AbstractStrategy lastKConflicts(Solver SOLVER, int K, AbstractStrategy STRAT) {
        return new LastConflict(SOLVER, STRAT, K);
    }

    public static AbstractStrategy<IntVar> generateAndTest(Solver SOLVER) {
        return new GenerateAndTest(SOLVER);
    }

    public static AbstractStrategy<IntVar> generateAndTest(Solver SOLVER, AbstractStrategy<IntVar> mainStrategy, int searchSpaceLimit) {
        return new GenerateAndTest(SOLVER, mainStrategy, searchSpaceLimit);
    }
}

