/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.assignments;

import java.io.Serializable;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public abstract class DecisionOperator<V extends Variable>
implements Serializable {
    public static DecisionOperator<IntVar> int_eq = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.instantiateTo(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.removeValue(value, cause);
        }

        @Override
        public String toString() {
            return " == ";
        }

        @Override
        public boolean isValid(IntVar var, int value) {
            return var.contains(value);
        }

        @Override
        public DecisionOperator opposite() {
            return int_neq;
        }
    };
    public static DecisionOperator<IntVar> int_neq = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.removeValue(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.instantiateTo(value, cause);
        }

        @Override
        public String toString() {
            return " != ";
        }

        @Override
        public boolean isValid(IntVar var, int value) {
            return var.contains(value);
        }

        @Override
        public DecisionOperator opposite() {
            return int_eq;
        }
    };
    public static DecisionOperator<IntVar> int_split = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateUpperBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateLowerBound(value + 1, cause);
        }

        @Override
        public String toString() {
            return " <= ";
        }

        @Override
        public boolean isValid(IntVar var, int value) {
            return var.getUB() >= value;
        }

        @Override
        public DecisionOperator opposite() {
            return int_reverse_split;
        }
    };
    public static DecisionOperator<IntVar> int_reverse_split = new DecisionOperator<IntVar>(){

        @Override
        public void apply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateLowerBound(value, cause);
        }

        @Override
        public void unapply(IntVar var, int value, ICause cause) throws ContradictionException {
            var.updateUpperBound(value - 1, cause);
        }

        @Override
        public String toString() {
            return " >= ";
        }

        @Override
        public boolean isValid(IntVar var, int value) {
            return var.getLB() <= value;
        }

        @Override
        public DecisionOperator opposite() {
            return int_split;
        }
    };
    public static DecisionOperator<SetVar> set_force = new DecisionOperator<SetVar>(){

        @Override
        public void apply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.addToKernel(element, cause);
        }

        @Override
        public void unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.removeFromEnvelope(element, cause);
        }

        @Override
        public String toString() {
            return " contains ";
        }

        @Override
        public boolean isValid(SetVar var, int element) {
            return var.envelopeContains(element) && !var.kernelContains(element);
        }

        @Override
        public DecisionOperator opposite() {
            return set_remove;
        }
    };
    public static DecisionOperator<SetVar> set_remove = new DecisionOperator<SetVar>(){

        @Override
        public void apply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.removeFromEnvelope(element, cause);
        }

        @Override
        public void unapply(SetVar var, int element, ICause cause) throws ContradictionException {
            var.addToKernel(element, cause);
        }

        @Override
        public String toString() {
            return " !contains ";
        }

        @Override
        public boolean isValid(SetVar var, int element) {
            return var.envelopeContains(element) && !var.kernelContains(element);
        }

        @Override
        public DecisionOperator opposite() {
            return set_force;
        }
    };

    public abstract void apply(V var1, int var2, ICause var3) throws ContradictionException;

    public abstract void unapply(V var1, int var2, ICause var3) throws ContradictionException;

    public abstract DecisionOperator opposite();

    public abstract String toString();

    public abstract boolean isValid(V var1, int var2);
}

