/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.Variable;

public abstract class Decision<V extends Variable>
implements Identity,
ICause,
Comparable<Decision<V>> {
    public static int _ID = 0;
    final int id = _ID++;
    protected V var;
    protected int branch;
    int worldIndex;
    protected Decision previous;
    protected boolean once;

    @Override
    public final int getId() {
        return this.id;
    }

    public void setPrevious(Decision decision) {
        this.previous = decision;
    }

    public Decision getPrevious() {
        return this.previous;
    }

    public void setWorldIndex(int wi) {
        this.worldIndex = wi;
    }

    public int getWorldIndex() {
        return this.worldIndex;
    }

    public boolean hasNext() {
        return this.branch < 2 && !this.once;
    }

    public void buildNext() {
        ++this.branch;
    }

    public void once(boolean once) {
        this.once = once;
    }

    protected void set(V var) {
        this.var = var;
        this.branch = 0;
        this.once = false;
        this.setWorldIndex(var.getSolver().getEnvironment().getWorldIndex());
    }

    public abstract void apply() throws ContradictionException;

    public void rewind() {
        this.branch = 0;
    }

    public V getDecisionVariable() {
        return this.var;
    }

    public abstract Object getDecisionValue();

    public abstract void free();

    public void reverse() {
        throw new UnsupportedOperationException();
    }

    public Decision<V> duplicate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        if (this.branch == 1) {
            e.add(xengine.explain(this.getPositiveDeduction(xengine)));
        } else if (this.branch == 2) {
            e.add(xengine.explain(this.getNegativeDeduction(xengine)));
        } else {
            throw new SolverException("Cannot explain a decision which has not been applied or refuted: " + this);
        }
    }

    public Deduction getNegativeDeduction(ExplanationEngine xengine) {
        return xengine.getDecision(this, false);
    }

    public Deduction getPositiveDeduction(ExplanationEngine xengine) {
        return xengine.getDecision(this, true);
    }

    @Override
    public int compareTo(Decision<V> o) {
        if (o.getDecisionVariable().getId() == this.getDecisionVariable().getId() && o.getDecisionValue().equals(this.getDecisionValue())) {
            return 0;
        }
        return 1;
    }
}

