/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision.fast;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.PoolManager;

public class FastDecision
extends Decision<IntVar> {
    int value;
    DecisionOperator<IntVar> assignment;
    final PoolManager<FastDecision> poolManager;

    public FastDecision(PoolManager<FastDecision> poolManager) {
        this.poolManager = poolManager;
    }

    @Override
    public Integer getDecisionValue() {
        return this.value;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            this.assignment.apply((IntVar)this.var, this.value, this);
        } else if (this.branch == 2) {
            this.assignment.unapply((IntVar)this.var, this.value, this);
        }
    }

    public void set(IntVar v, int value, DecisionOperator<IntVar> assignment) {
        super.set(v);
        this.value = value;
        this.assignment = assignment;
    }

    @Override
    public void reverse() {
        this.assignment = this.assignment.opposite();
    }

    @Override
    public void free() {
        this.previous = null;
        this.poolManager.returnE(this);
    }

    @Override
    public Decision<IntVar> duplicate() {
        FastDecision d = this.poolManager.getE();
        if (d == null) {
            d = new FastDecision(this.poolManager);
        }
        d.set((IntVar)this.var, this.value, this.assignment);
        return d;
    }

    public String toString() {
        return String.format("%s%s %s %s (%d)", this.branch < 2 ? "" : "!", ((IntVar)this.var).getName(), this.assignment.toString(), this.value, this.branch);
    }

    @Override
    public int compareTo(Decision<IntVar> o) {
        if (super.compareTo(o) == 0 && o.getClass().isInstance(this)) {
            FastDecision fd = (FastDecision)o;
            if (fd.assignment == this.assignment) {
                return 0;
            }
            return 1;
        }
        return 1;
    }
}

