/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision.fast;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.util.PoolManager;

public class FastDecisionReal
extends Decision<RealVar> {
    double value;
    final PoolManager<FastDecisionReal> poolManager;

    public FastDecisionReal(PoolManager<FastDecisionReal> poolManager) {
        this.poolManager = poolManager;
    }

    @Override
    public Double getDecisionValue() {
        return this.value;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            ((RealVar)this.var).updateUpperBound(this.value, this);
        } else if (this.branch == 2) {
            ((RealVar)this.var).updateLowerBound(this.value, this);
        }
    }

    public void set(RealVar v, double value) {
        super.set(v);
        this.value = value;
    }

    @Override
    public void free() {
        this.previous = null;
        this.poolManager.returnE(this);
    }

    public String toString() {
        return String.format("%s%s %s %s (%d)", this.branch < 2 ? "" : "!", ((RealVar)this.var).getName(), "<=", this.value, this.branch);
    }
}

