/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Random;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.search.loop.monitors.FailPerPropagator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.search.strategy.selectors.IntValueSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.PoolManager;

public class DomOverWDeg
extends AbstractStrategy<IntVar>
implements IVariableMonitor<IntVar> {
    IntVar[] variables;
    FailPerPropagator counter;
    TIntObjectHashMap<IStateInt> pid2ari;
    TIntIntHashMap pid2arity;
    TIntList bests;
    Random random;
    PoolManager<FastDecision> decisionPool;
    IntValueSelector valueSelector;

    public DomOverWDeg(IntVar[] variables, long seed, IntValueSelector valueSelector) {
        super((Variable[])variables);
        this.variables = (IntVar[])variables.clone();
        Solver solver = variables[0].getSolver();
        this.counter = new FailPerPropagator(solver.getCstrs(), solver);
        this.pid2ari = new TIntObjectHashMap();
        this.pid2arity = new TIntIntHashMap(10, 0.5f, -1, -1);
        this.bests = new TIntArrayList();
        this.valueSelector = valueSelector;
        this.decisionPool = new PoolManager();
        this.random = new Random(seed);
    }

    @Override
    public void init() throws ContradictionException {
        IEnvironment env = ((IntVar[])this.vars)[0].getSolver().getEnvironment();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].addMonitor(this);
            Propagator[] props = this.variables[i].getPropagators();
            for (int j = 0; j < props.length; ++j) {
                this.pid2ari.putIfAbsent(props[j].getId(), env.makeInt(props[j].arity()));
            }
        }
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int currentVal = this.valueSelector.selectValue(variable);
        FastDecision currrent = this.decisionPool.getE();
        if (currrent == null) {
            currrent = new FastDecision(this.decisionPool);
        }
        currrent.set(variable, currentVal, DecisionOperator.int_eq);
        return currrent;
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar best = null;
        this.bests.clear();
        this.pid2arity.clear();
        long _d1 = Integer.MAX_VALUE;
        long _d2 = 0L;
        for (int idx = 0; idx < ((IntVar[])this.vars).length; ++idx) {
            int weight;
            int dsize = this.variables[idx].getDomainSize();
            if (dsize <= 1) continue;
            long c1 = (long)dsize * _d2;
            int degree = this.variables[idx].getNbProps();
            long c2 = _d1 * (long)degree * (long)(weight = this.weight(this.variables[idx]));
            if (c1 < c2) {
                this.bests.clear();
                this.bests.add(idx);
                _d1 = dsize;
                _d2 = degree * weight;
                continue;
            }
            if (c1 != c2) continue;
            this.bests.add(idx);
        }
        if (this.bests.size() > 0) {
            int currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = ((IntVar[])this.vars)[currentVar];
        }
        return this.computeDecision(best);
    }

    private int weight(IntVar v) {
        int w = 1;
        Propagator[] propagators = v.getPropagators();
        for (int p = 0; p < propagators.length; ++p) {
            Propagator prop = propagators[p];
            int pid = prop.getId();
            if (this.pid2arity.get(pid) > 1) {
                w += this.counter.getFails(prop);
                continue;
            }
            if (this.pid2ari.get(pid) == null) {
                this.pid2ari.putIfAbsent(prop.getId(), v.getSolver().getEnvironment().makeInt(prop.arity()));
            }
            int a = this.pid2ari.get(pid).get();
            this.pid2arity.put(pid, a);
            if (a <= 1) continue;
            w += this.counter.getFails(prop);
        }
        return w;
    }

    @Override
    public void onUpdate(IntVar var, IEventType evt) {
        if (evt == IntEventType.INSTANTIATE) {
            Propagator[] props = var.getPropagators();
            for (int i = 0; i < props.length; ++i) {
                int pid = props[i].getId();
                this.pid2ari.get(pid).add(-1);
            }
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        throw new SolverException("DomOverWDeg does not modify variables on IVariableMonitor.onUpdate.\nSo it cannot explain value removals.");
    }
}

