/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.explanations.VariableState;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.iterators.DisposableValueIterator;

public class ImpactBased
extends AbstractStrategy<IntVar>
implements IMonitorDownBranch,
IMonitorRestart,
IMonitorContradiction,
ICause {
    protected final int aging;
    protected double[][] Ilabel;
    protected int[] offsets;
    protected int split;
    protected IStateDouble searchSpaceSize;
    protected int currentVar = -1;
    protected int currentVal = -1;
    TIntList bests = new TIntArrayList();
    Random random;
    protected int nodeImpact;
    PoolManager<FastDecision> decisionPool;
    protected Solver solver;
    protected boolean asgntFailed;
    protected boolean learnsAndFails;
    protected IntVar lAfVar;
    protected long timeLimit = Integer.MAX_VALUE;

    public ImpactBased(IntVar[] ivariables, int alpha, int split, int nodeImpact, long seed, boolean initOnly) {
        super((Variable[])ivariables);
        this.solver = ivariables[0].getSolver();
        this.aging = alpha;
        this.split = (int)Math.pow(2.0, split);
        this.searchSpaceSize = this.solver.getEnvironment().makeFloat();
        this.random = new Random(seed);
        this.decisionPool = new PoolManager();
        this.nodeImpact = nodeImpact;
        if (!initOnly) {
            this.solver.plugMonitor(this);
        }
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        if (this.currentVar == -1 || ((IntVar[])this.vars)[this.currentVar] != variable) {
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (((IntVar[])this.vars)[i] != variable) continue;
                this.currentVar = i;
            }
            assert (((IntVar[])this.vars)[this.currentVar] == variable);
        }
        this.bests.clear();
        double bestImpact = 1.0;
        if (variable.hasEnumeratedDomain()) {
            DisposableValueIterator it = variable.getValueIterator(true);
            int o = this.offsets[this.currentVar];
            while (it.hasNext()) {
                int val = it.next();
                double impact = this.Ilabel[this.currentVar][val - o];
                if (impact < bestImpact) {
                    this.bests.clear();
                    this.bests.add(val);
                    bestImpact = impact;
                    continue;
                }
                if (impact != bestImpact) continue;
                this.bests.add(val);
            }
            it.dispose();
            this.currentVal = this.bests.get(this.random.nextInt(this.bests.size()));
        } else {
            int lb = variable.getLB();
            int ub = variable.getUB();
            this.currentVal = this.random.nextBoolean() ? lb : ub;
        }
        FastDecision currrent = this.decisionPool.getE();
        if (currrent == null) {
            currrent = new FastDecision(this.decisionPool);
        }
        currrent.set(variable, this.currentVal, DecisionOperator.int_eq);
        return currrent;
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar best = null;
        this.bests.clear();
        double bestImpact = -1.7976931348623157E308;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            double imp = this.computeImpact(i);
            if (imp > bestImpact) {
                this.bests.clear();
                this.bests.add(i);
                bestImpact = imp;
                continue;
            }
            if (imp != bestImpact) continue;
            this.bests.add(i);
        }
        if (this.bests.size() > 0) {
            this.currentVar = this.bests.get(this.random.nextInt(this.bests.size()));
            best = ((IntVar[])this.vars)[this.currentVar];
        }
        return this.computeDecision(best);
    }

    public void setTimeLimit(long timeLimit) {
        if (timeLimit > -1L) {
            this.timeLimit = timeLimit;
        }
    }

    @Override
    public void init() throws ContradictionException {
        int dsz;
        int UB;
        int offset;
        IntVar v;
        int i;
        long tl = System.currentTimeMillis() + this.timeLimit;
        this.Ilabel = new double[((IntVar[])this.vars).length][];
        this.offsets = new int[((IntVar[])this.vars).length];
        double before = this.searchSpaceSize();
        this.searchSpaceSize.set(before);
        this.learnsAndFails = false;
        block0: for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
            v = ((IntVar[])this.vars)[i];
            offset = v.getLB();
            UB = v.getUB();
            dsz = UB - offset + 1;
            if (v.isInstantiated()) continue;
            this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
            this.offsets[i] = offset;
            if (v.hasEnumeratedDomain()) {
                if (v.getDomainSize() < this.split) {
                    DisposableValueIterator it = v.getValueIterator(true);
                    while (it.hasNext()) {
                        double im;
                        if (System.currentTimeMillis() > tl) break block0;
                        int a = it.next();
                        this.Ilabel[i][a - offset] = im = this.computeImpact(v, a, before);
                    }
                    it.dispose();
                    continue;
                }
                int step = 0;
                int size = dsz / this.split;
                DisposableValueIterator it = v.getValueIterator(true);
                while (it.hasNext()) {
                    if (System.currentTimeMillis() > tl) break block0;
                    int a = it.next();
                    double im = step % size == 0 ? this.computeImpact(v, a, before) : this.Ilabel[i][a - 1 - offset];
                    this.Ilabel[i][a - offset] = im;
                    ++step;
                }
                it.dispose();
                continue;
            }
            if (System.currentTimeMillis() > tl) break;
            double i1 = this.computeImpact(v, v.getLB(), before);
            double i2 = this.computeImpact(v, v.getUB(), before);
            double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
            this.Ilabel[i][0] = (i1 + i2 + i3) / 3.0;
        }
        if (this.learnsAndFails) {
            this.learnsAndFails = false;
            this.solver.getEngine().fails(this, this.lAfVar, "Impact::init:: detect failures");
        } else if (System.currentTimeMillis() > tl) {
            LOGGER.debug("impact Search stops its init phase -- reach time limit!");
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                v = ((IntVar[])this.vars)[i];
                offset = v.getLB();
                UB = v.getUB();
                dsz = UB - offset + 1;
                if (v.isInstantiated() || this.Ilabel[i] != null) continue;
                this.Ilabel[i] = new double[v.hasEnumeratedDomain() ? dsz : 1];
                this.offsets[i] = offset;
            }
        }
    }

    @Override
    public void beforeDownLeftBranch() {
    }

    @Override
    public void afterDownLeftBranch() {
        if (this.currentVar > -1) {
            if (this.asgntFailed) {
                this.updateImpact(1.0, this.currentVar, this.currentVal);
            } else {
                double sssz = this.searchSpaceSize();
                this.updateImpact(sssz / this.searchSpaceSize.get(), this.currentVar, this.currentVal);
                this.searchSpaceSize.set(sssz);
            }
            this.currentVar = -1;
        }
        this.asgntFailed = false;
        this.reevaluateImpact();
    }

    @Override
    public void beforeDownRightBranch() {
    }

    @Override
    public void afterDownRightBranch() {
        this.reevaluateImpact();
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        this.asgntFailed = true;
    }

    protected double computeImpact(int idx) {
        IntVar var = ((IntVar[])this.vars)[idx];
        if (var.hasEnumeratedDomain()) {
            int of = this.offsets[idx];
            DisposableValueIterator it = var.getValueIterator(true);
            double impact = 0.0;
            while (it.hasNext()) {
                int val = it.next();
                impact += this.Ilabel[idx][val - of];
            }
            it.dispose();
            return impact - (double)var.getDomainSize();
        }
        return this.Ilabel[idx][0] - (double)var.getDomainSize();
    }

    private double computeImpact(IntVar v, int a, double before) {
        this.solver.getEnvironment().worldPush();
        try {
            v.instantiateTo(a, this);
            this.solver.getEngine().propagate();
            double after = this.searchSpaceSize();
            this.solver.getEnvironment().worldPop();
            return 1.0 - after / before;
        }
        catch (ContradictionException e) {
            this.solver.getEngine().flush();
            this.solver.getEnvironment().worldPop();
            try {
                v.removeValue(a, this);
                this.solver.getEngine().propagate();
            }
            catch (ContradictionException ex) {
                this.learnsAndFails = true;
                this.lAfVar = v;
                this.solver.getEngine().flush();
            }
            return 1.0;
        }
    }

    protected void updateImpact(double nImpact, int varIdx, int valIdx) {
        valIdx = this.Ilabel[varIdx].length > 1 ? valIdx - this.offsets[varIdx] : 0;
        double impact = this.Ilabel[varIdx][valIdx] * (double)(this.aging - 1);
        impact += nImpact;
        this.Ilabel[varIdx][valIdx] = impact /= (double)this.aging;
    }

    protected double searchSpaceSize() {
        double size = 1.0;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            assert ((size *= (double)((IntVar[])this.vars)[i].getDomainSize()) > 0.0) : "Search space is not correct!";
        }
        if (size == Double.POSITIVE_INFINITY) {
            size = Double.MAX_VALUE;
        }
        return size;
    }

    protected void reevaluateImpact() {
        if (this.nodeImpact > 0 && this.solver.getMeasures().getNodeCount() % (long)this.nodeImpact == 0L) {
            double before = this.searchSpaceSize.get();
            this.learnsAndFails = false;
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                IntVar v = ((IntVar[])this.vars)[i];
                int dsz = v.getDomainSize();
                if (v.isInstantiated()) continue;
                int offset = v.getLB();
                if (v.hasEnumeratedDomain()) {
                    if (v.getDomainSize() < this.split) {
                        DisposableValueIterator it = v.getValueIterator(true);
                        while (it.hasNext()) {
                            int a = it.next();
                            double im = this.computeImpact(v, a, before);
                            this.updateImpact(im, i, a);
                        }
                        it.dispose();
                        continue;
                    }
                    int step = 0;
                    int size = dsz / this.split;
                    DisposableValueIterator it = v.getValueIterator(true);
                    while (it.hasNext()) {
                        int a = it.next();
                        double im = step % size == 0 ? this.computeImpact(v, a, before) : this.Ilabel[i][a - 1 - offset];
                        this.updateImpact(im, i, a);
                        ++step;
                    }
                    it.dispose();
                    continue;
                }
                double i1 = this.computeImpact(v, v.getLB(), before);
                double i2 = this.computeImpact(v, v.getUB(), before);
                double i3 = this.computeImpact(v, (v.getLB() + v.getUB()) / 2, before);
                this.updateImpact((i1 + i2 + i3) / 3.0, i, 0);
            }
            if (this.learnsAndFails) {
                this.learnsAndFails = false;
                this.solver.getSearchLoop().moveTo(16);
                this.solver.getSearchLoop().getSMList().onContradiction(this.solver.getEngine().getContradictionException().set(this, this.lAfVar, "Impact::reevaluate:: detect failures"));
            }
        }
    }

    @Override
    public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
        for (IntVar v : (IntVar[])this.vars) {
            v.explain(xengine, VariableState.DOM, e);
        }
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
    }
}

