/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.io.Serializable;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStrategy<V extends Variable>
implements Serializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractStrategy.class);
    protected final V[] vars;

    protected AbstractStrategy(V[] variables) {
        this.vars = (Variable[])variables.clone();
    }

    public abstract void init() throws ContradictionException;

    public abstract Decision<V> getDecision();

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        for (V v : this.vars) {
            s.append(v).append(' ');
        }
        return s.toString();
    }

    public Decision<V> computeDecision(V var) {
        return null;
    }

    public V[] getVariables() {
        return this.vars;
    }
}

