/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class FindAndProve<V extends Variable>
extends AbstractStrategy<V> {
    AbstractStrategy find;
    AbstractStrategy prove;
    Solver solver;

    public FindAndProve(V[] vars, AbstractStrategy<V> heurToFindASol, AbstractStrategy<V> heurToProveOpt) {
        super(vars);
        this.find = heurToFindASol;
        this.prove = heurToProveOpt;
        this.solver = vars[0].getSolver();
    }

    @Override
    public void init() throws ContradictionException {
        this.find.init();
        this.prove.init();
    }

    @Override
    public Decision getDecision() {
        if (this.solver.getMeasures().getSolutionCount() == 0L) {
            return this.find.getDecision();
        }
        return this.prove.getDecision();
    }

    @Override
    public Decision<V> computeDecision(V variable) {
        if (this.solver.getMeasures().getSolutionCount() == 0L) {
            return this.find.computeDecision(variable);
        }
        return this.prove.computeDecision(variable);
    }
}

