/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.memory.structure.Operation;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class GenerateAndTest
extends AbstractStrategy<IntVar> {
    Solver solver;
    GenerateAndTestDecision gAtDec;
    GenerateAndTestPropagationEngine gAtPE;
    Operation restorePropagationEngine;
    int searchSpaceLimit = -1;
    AbstractStrategy<IntVar> mainStrategy = null;

    private static IntVar[] extractIntVars(Solver solver) {
        IntVar[] ivars = ArrayUtils.append(solver.retrieveBoolVars(), solver.retrieveIntVars());
        if (ivars.length != solver.getNbVars()) {
            throw new SolverException("GenerateAndTest search cannot be applied on non integer (and boolean) variables");
        }
        return ivars;
    }

    public GenerateAndTest(Solver solver) {
        super((Variable[])GenerateAndTest.extractIntVars(solver));
        this.solver = solver;
    }

    public GenerateAndTest(Solver solver, AbstractStrategy<IntVar> mainStrategy, int searchSpaceLimit) {
        super((Variable[])GenerateAndTest.extractIntVars(solver));
        this.solver = solver;
        this.searchSpaceLimit = searchSpaceLimit;
        this.mainStrategy = mainStrategy;
    }

    @Override
    public void init() throws ContradictionException {
        this.gAtDec = new GenerateAndTestDecision((IntVar[])this.vars);
        this.gAtPE = new GenerateAndTestPropagationEngine(this.solver);
        final IPropagationEngine stdEngine = this.solver.getEngine();
        this.restorePropagationEngine = new Operation(){

            @Override
            public void undo() {
                GenerateAndTest.this.solver.set(stdEngine);
            }
        };
    }

    @Override
    public Decision<IntVar> getDecision() {
        if (this.searchSpaceLimit > -1 && !this.remainingSpace(this.searchSpaceLimit)) {
            return this.mainStrategy.getDecision();
        }
        if (this.solver.getEngine() != this.gAtPE && this.gAtDec.init()) {
            this.solver.getEnvironment().save(this.restorePropagationEngine);
            this.solver.set(this.gAtPE);
            return this.gAtDec;
        }
        return null;
    }

    private boolean remainingSpace(int limit) {
        int size = 1;
        for (int i = 0; i < ((IntVar[])this.vars).length && size < limit; size *= ((IntVar[])this.vars)[i].getDomainSize(), ++i) {
        }
        return size < limit;
    }

    private static class GenerateAndTestPropagationEngine
    implements IPropagationEngine {
        private final ContradictionException e = new ContradictionException();
        Propagator[] propagators = new Propagator[0];

        private GenerateAndTestPropagationEngine(Solver solver) {
            for (Constraint c : solver.getCstrs()) {
                this.propagators = ArrayUtils.append(this.propagators, c.getPropagators());
            }
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void propagate() throws ContradictionException {
            int sat = 0;
            for (int i = 0; i < this.propagators.length; ++i) {
                Propagator ptmp = this.propagators[i];
                if (ptmp.isActive()) {
                    ESat entail = ptmp.isEntailed();
                    if (entail.equals((Object)ESat.FALSE)) {
                        this.fails(ptmp, null, "GenerateAndTest");
                        continue;
                    }
                    if (!entail.equals((Object)ESat.TRUE)) continue;
                    ++sat;
                    continue;
                }
                ++sat;
            }
            if (sat != this.propagators.length) {
                throw new SolverException("GenerateAndTest has generated an incomplete instantiation");
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void fails(ICause cause, Variable variable, String message) throws ContradictionException {
            throw this.e.set(cause, variable, message);
        }

        @Override
        public ContradictionException getContradictionException() {
            return this.e;
        }

        @Override
        public void clear() {
        }

        @Override
        public void onVariableUpdate(Variable variable, IEventType type, ICause cause) throws ContradictionException {
        }

        @Override
        public void delayedPropagation(Propagator propagator, PropagatorEventType type) throws ContradictionException {
        }

        @Override
        public void onPropagatorExecution(Propagator propagator) {
        }

        @Override
        public void desactivatePropagator(Propagator propagator) {
        }

        @Override
        public void dynamicAddition(Constraint c, boolean permanent) {
            throw new SolverException("GenerateAndTest does not support propagator dynamic addition");
        }

        @Override
        public void dynamicDeletion(Constraint c) {
            throw new SolverException("GenerateAndTest does not support propagator dynamic deletion");
        }
    }

    private static class GenerateAndTestDecision
    extends Decision<IntVar> {
        final IntVar[] variables;
        final int nVars;
        final int[] ivalues;
        boolean free = true;

        protected GenerateAndTestDecision(IntVar[] variables) {
            this.variables = variables;
            this.nVars = variables.length;
            this.ivalues = new int[this.nVars];
        }

        protected boolean init() {
            int nbInst = 0;
            for (int j = 0; j < this.nVars; ++j) {
                this.ivalues[j] = this.variables[j].getLB();
                if (!this.variables[j].isInstantiated()) continue;
                ++nbInst;
            }
            this.free = false;
            return nbInst < this.nVars;
        }

        @Override
        public boolean hasNext() {
            int vIdx;
            for (vIdx = 0; vIdx < this.nVars; ++vIdx) {
                this.ivalues[vIdx] = this.variables[vIdx].nextValue(this.ivalues[vIdx]);
                int v = this.ivalues[vIdx];
                if (v < Integer.MAX_VALUE) {
                    return true;
                }
                this.ivalues[vIdx] = this.variables[vIdx].getLB();
            }
            return vIdx < this.nVars;
        }

        @Override
        public void buildNext() {
        }

        @Override
        public void apply() throws ContradictionException {
            for (int i = 0; i < this.variables.length; ++i) {
                if (this.variables[i].isInstantiated()) continue;
                this.variables[i].instantiateTo(this.ivalues[i], this);
            }
        }

        @Override
        public Object getDecisionValue() {
            return this.ivalues;
        }

        @Override
        public void free() {
            this.free = true;
        }

        public String toString() {
            StringBuilder st = new StringBuilder("[GenerateAndTest]<");
            for (int i = 0; i < this.variables.length; ++i) {
                st.append(this.ivalues[i]).append(", ");
            }
            st.deleteCharAt(st.length() - 1);
            st.deleteCharAt(st.length() - 1);
            st.append(">");
            return st.toString();
        }
    }
}

