/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecision;
import org.chocosolver.solver.search.strategy.selectors.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;

public class IntStrategy
extends AbstractStrategy<IntVar> {
    VariableSelector<IntVar> variableSelector;
    IntValueSelector valueSelector;
    DecisionOperator<IntVar> decisionOperator;
    PoolManager<FastDecision> decisionPool;

    public IntStrategy(IntVar[] scope, VariableSelector<IntVar> varSelector, IntValueSelector valSelector) {
        this(scope, varSelector, valSelector, DecisionOperator.int_eq);
    }

    public IntStrategy(IntVar[] scope, VariableSelector<IntVar> varSelector, IntValueSelector valSelector, DecisionOperator<IntVar> decOperator) {
        super((Variable[])scope);
        this.variableSelector = varSelector;
        this.valueSelector = valSelector;
        this.decisionOperator = decOperator;
        this.decisionPool = new PoolManager();
    }

    @Override
    public void init() {
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        int value = this.valueSelector.selectValue(variable);
        FastDecision d = this.decisionPool.getE();
        if (d == null) {
            d = new FastDecision(this.decisionPool);
        }
        d.set(variable, value, this.decisionOperator);
        return d;
    }

    @Override
    public Decision getDecision() {
        IntVar variable = (IntVar)this.variableSelector.getVariable(this.vars);
        return this.computeDecision(variable);
    }
}

