/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class LastConflict
extends AbstractStrategy<Variable>
implements IMonitorRestart,
IMonitorSolution,
IMonitorContradiction {
    protected Solver solver;
    protected AbstractStrategy<Variable> mainStrategy;
    protected boolean active;
    protected int nbCV;
    protected Variable[] conflictingVariables;

    public LastConflict(Solver solver, AbstractStrategy<Variable> mainStrategy, int k) {
        super(mainStrategy.vars);
        assert (k > 0) : "parameter K of last conflict must be strictly positive!";
        this.solver = solver;
        this.mainStrategy = mainStrategy;
        solver.getSearchLoop().plugSearchMonitor(this);
        this.conflictingVariables = new Variable[k];
        this.nbCV = 0;
        this.active = false;
    }

    @Override
    public void init() throws ContradictionException {
        this.mainStrategy.init();
    }

    @Override
    public Decision getDecision() {
        Decision<Variable> d;
        Variable decVar;
        if (this.active && (decVar = this.firstNotInst()) != null && (d = this.mainStrategy.computeDecision(decVar)) != null) {
            return d;
        }
        this.active = true;
        return this.mainStrategy.getDecision();
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        Object curDecVar = this.solver.getSearchLoop().getLastDecision().getDecisionVariable();
        if (this.nbCV > 0 && this.conflictingVariables[this.nbCV - 1] == curDecVar) {
            return;
        }
        if (this.inScope((Variable)curDecVar)) {
            if (this.nbCV < this.conflictingVariables.length) {
                this.conflictingVariables[this.nbCV++] = curDecVar;
            } else {
                assert (this.nbCV == this.conflictingVariables.length);
                System.arraycopy(this.conflictingVariables, 1, this.conflictingVariables, 0, this.nbCV - 1);
                this.conflictingVariables[this.nbCV - 1] = curDecVar;
            }
        }
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        this.active = false;
    }

    @Override
    public void onSolution() {
        this.active = false;
    }

    private Variable firstNotInst() {
        for (int i = this.nbCV - 1; i >= 0; --i) {
            if (this.conflictingVariables[i].isInstantiated()) continue;
            return this.conflictingVariables[i];
        }
        return null;
    }

    private boolean inScope(Variable target) {
        V[] scope = this.mainStrategy.vars;
        for (int v = 0; v < scope.length; ++v) {
            if (scope[v].getId() != target.getId()) continue;
            return true;
        }
        return false;
    }
}

