/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecisionReal;
import org.chocosolver.solver.search.strategy.selectors.RealValueSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;

public class RealStrategy
extends AbstractStrategy<RealVar> {
    VariableSelector<RealVar> varselector;
    RealValueSelector valueIterator;
    PoolManager<FastDecisionReal> decisionPool;

    public RealStrategy(RealVar[] scope, VariableSelector<RealVar> varselector, RealValueSelector valueIterator) {
        super((Variable[])scope);
        this.varselector = varselector;
        this.valueIterator = valueIterator;
        this.decisionPool = new PoolManager();
    }

    @Override
    public void init() {
    }

    @Override
    public Decision<RealVar> computeDecision(RealVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        double value = this.valueIterator.selectValue(variable);
        FastDecisionReal d = this.decisionPool.getE();
        if (d == null) {
            d = new FastDecisionReal(this.decisionPool);
        }
        d.set(variable, value);
        return d;
    }

    @Override
    public Decision getDecision() {
        RealVar variable = (RealVar)this.varselector.getVariable(this.vars);
        return this.computeDecision(variable);
    }
}

