/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.fast.FastDecisionSet;
import org.chocosolver.solver.search.strategy.selectors.SetValueSelector;
import org.chocosolver.solver.search.strategy.selectors.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.PoolManager;

public class SetStrategy
extends AbstractStrategy<SetVar> {
    protected PoolManager<FastDecisionSet> pool;
    protected VariableSelector<SetVar> varSelector;
    protected SetValueSelector valSelector;
    protected DecisionOperator<SetVar> operator;

    public SetStrategy(SetVar[] scope, VariableSelector<SetVar> varS, SetValueSelector valS, boolean enforceFirst) {
        super((Variable[])scope);
        this.varSelector = varS;
        this.valSelector = valS;
        this.operator = enforceFirst ? DecisionOperator.set_force : DecisionOperator.set_remove;
        this.pool = new PoolManager();
    }

    @Override
    public void init() throws ContradictionException {
    }

    @Override
    public Decision<SetVar> getDecision() {
        SetVar variable = (SetVar)this.varSelector.getVariable(this.vars);
        return this.computeDecision(variable);
    }

    @Override
    public Decision<SetVar> computeDecision(SetVar s) {
        if (s == null) {
            return null;
        }
        assert (!s.isInstantiated());
        FastDecisionSet d = this.pool.getE();
        if (d == null) {
            d = new FastDecisionSet(this.pool);
        }
        d.set(s, this.valSelector.selectValue(s), this.operator);
        return d;
    }
}

