/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.thread;

import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.objective.ObjectiveManager;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.propagation.hardcoded.TwoBucketPropagationEngine;
import org.chocosolver.solver.variables.IntVar;

public class ThreadSolver
extends Thread {
    public Solver solver;
    private long creationTime;
    private boolean saf = true;

    public ThreadSolver(Solver solver) {
        this.creationTime -= System.nanoTime();
        this.solver = solver;
    }

    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public void run() {
        if (this.solver.getEngine() == NoPropagationEngine.SINGLETON) {
            this.solver.set(new TwoBucketPropagationEngine(this.solver));
        }
        this.solver.getMeasures().setReadingTimeCount(this.creationTime + System.nanoTime());
        this.solver.getSearchLoop().launch(this.saf);
    }

    public void findSolution() {
        this.solver.set(ObjectiveManager.SAT());
        this.saf = true;
        this.start();
    }

    public void findAllSolutions() {
        this.solver.set(ObjectiveManager.SAT());
        this.saf = false;
        this.start();
    }

    public void findOptimalSolution(ResolutionPolicy policy, IntVar objective) {
        if (policy == ResolutionPolicy.SATISFACTION) {
            throw new UnsupportedOperationException("cannot optimize a satisfaction problem!");
        }
        this.saf = false;
        this.solver.set(new ObjectiveManager(objective, policy, true));
        this.start();
    }
}

