/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorClose;
import org.chocosolver.solver.search.loop.monitors.IMonitorDownBranch;
import org.chocosolver.solver.search.loop.monitors.IMonitorInitialize;
import org.chocosolver.solver.trace.IMessage;
import org.chocosolver.solver.trace.LogStatEveryXXms;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.StringUtils;

public class Chatterbox {
    private Chatterbox() {
    }

    public static void printVersion(Solver solver) {
        System.out.println(solver.getSettings().getWelcomeMessage());
    }

    public static void printStatistics(Solver solver) {
        System.out.println(solver.getMeasures().toString());
    }

    public static void printShortStatistics(Solver solver) {
        System.out.println(solver.getMeasures().toOneLineString());
    }

    public static void printCSVStatistics(Solver solver) {
        System.out.println(solver.getMeasures().toCSV());
    }

    public static void showStatistics(final Solver solver) {
        solver.plugMonitor(new IMonitorInitialize(){

            @Override
            public void beforeInitialize() {
                Chatterbox.printVersion(solver);
            }

            @Override
            public void afterInitialize() {
            }
        });
        solver.plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                Chatterbox.printStatistics(solver);
            }

            @Override
            public void afterClose() {
            }
        });
    }

    public static void showShortStatistics(final Solver solver) {
        solver.plugMonitor(new IMonitorClose(){

            @Override
            public void beforeClose() {
                System.out.println(solver.getMeasures().toOneLineString());
            }

            @Override
            public void afterClose() {
            }
        });
    }

    public static void showSolutions(Solver solver, IMessage message) {
        solver.plugMonitor(() -> System.out.println(message.print()));
    }

    public static void showSolutions(Solver solver) {
        Chatterbox.showSolutions(solver, new DefaultSolutionMessage(solver));
    }

    public static void showDecisions(final Solver solver, final IMessage message) {
        solver.plugMonitor(new IMonitorDownBranch(){

            @Override
            public void beforeDownLeftBranch() {
                System.out.println(String.format("%s[L]%s //%s", StringUtils.pad("", solver.getEnvironment().getWorldIndex(), "."), solver.getSearchLoop().getLastDecision().toString(), message.print()));
            }

            @Override
            public void afterDownLeftBranch() {
            }

            @Override
            public void beforeDownRightBranch() {
                System.out.println(String.format("%s[R]%s //%s", StringUtils.pad("", solver.getEnvironment().getWorldIndex(), "."), solver.getSearchLoop().getLastDecision().toString(), message.print()));
            }

            @Override
            public void afterDownRightBranch() {
            }
        });
    }

    public static void showDecisions(Solver solver) {
        Chatterbox.showDecisions(solver, new DefaultDecisionMessage(solver));
    }

    public static void showContradiction(Solver solver) {
        solver.plugMonitor(cex -> System.out.println(String.format("\t/!\\ %s", cex.toString())));
    }

    public static void showStatisticsDuringResolution(Solver solver, long f) {
        if (f > 0L) {
            solver.plugMonitor(new LogStatEveryXXms(solver, f));
        }
    }

    public static class DefaultDecisionMessage
    implements IMessage {
        private Solver solver;

        public DefaultDecisionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            int limit = 120;
            Variable[] vars = this.solver.getStrategy().getVariables();
            StringBuilder s = new StringBuilder(32);
            for (int i = 0; i < vars.length && s.length() < limit; ++i) {
                s.append(vars[i]).append(' ');
            }
            if (s.length() >= limit) {
                s.append("...");
            }
            return s.toString();
        }
    }

    public static class DefaultSolutionMessage
    implements IMessage {
        private Solver solver;

        public DefaultSolutionMessage(Solver solver) {
            this.solver = solver;
        }

        @Override
        public String print() {
            return String.format("- Solution #%s found. %s \n\t%s.", this.solver.getMeasures().getSolutionCount(), this.solver.getMeasures().toOneShortLineString(), this.print(this.solver.getStrategy().getVariables()));
        }

        private String print(Variable[] vars) {
            StringBuilder s = new StringBuilder(32);
            for (Variable v : vars) {
                s.append(v).append(' ');
            }
            return s.toString();
        }
    }
}

