/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import gnu.trove.map.hash.TObjectLongHashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.util.tools.StringUtils;

public class LogPropagationCount {
    public String print(Solver solver) {
        Constraint[] cstrs = solver.getCstrs();
        TObjectLongHashMap<String> fcounter = new TObjectLongHashMap<String>();
        TObjectLongHashMap<String> ccounter = new TObjectLongHashMap<String>();
        for (int i = 0; i < cstrs.length; ++i) {
            Propagator[] props = cstrs[i].getPropagators();
            for (int j = 0; j < props.length; ++j) {
                String clazz = props[j].getClass().getSimpleName();
                fcounter.adjustOrPutValue(clazz, props[j].fineERcalls, props[j].fineERcalls);
                ccounter.adjustOrPutValue(clazz, props[j].coarseERcalls, props[j].coarseERcalls);
            }
        }
        String[] classes = fcounter.keys(new String[fcounter.size()]);
        StringBuilder st = new StringBuilder();
        st.append(StringUtils.pad(" ", 50, "-")).append("\n");
        st.append("| ").append(StringUtils.pad("Name", 30, " "));
        st.append("| ").append(StringUtils.pad("fine", 7, " "));
        st.append("| coarse |\n");
        st.append(StringUtils.pad(" ", 50, "-")).append("\n");
        long fsum = 0L;
        long csum = 0L;
        for (int i = 0; i < classes.length; ++i) {
            st.append("| ").append(StringUtils.pad("" + classes[i], 30, " "));
            st.append("| ").append(StringUtils.pad("" + fcounter.get(classes[i]), -7, " "));
            fsum += fcounter.get(classes[i]);
            st.append("| ").append(StringUtils.pad("" + ccounter.get(classes[i]), -7, " "));
            csum += ccounter.get(classes[i]);
            st.append("|\n");
        }
        st.append(StringUtils.pad(" ", 50, "-")).append("\n");
        st.append("| ").append(StringUtils.pad("", 30, " "));
        st.append("| ").append(StringUtils.pad("" + fsum, -7, " "));
        st.append("| ").append(StringUtils.pad("" + csum, -7, " "));
        st.append("|\n");
        st.append(StringUtils.pad(" ", 50, "-")).append("\n");
        return st.toString();
    }
}

