/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.Deduction;
import org.chocosolver.solver.explanations.Explanation;
import org.chocosolver.solver.explanations.ExplanationEngine;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;

public class Task {
    private IntVar start;
    private IntVar duration;
    private IntVar end;
    private IVariableMonitor update;

    public Task(IntVar s, IntVar d, IntVar e) {
        this.start = s;
        this.duration = d;
        this.end = e;
        this.update = s.hasEnumeratedDomain() || d.hasEnumeratedDomain() || e.hasEnumeratedDomain() ? new IVariableMonitor(){

            public void onUpdate(Variable var, IEventType evt) throws ContradictionException {
                for (boolean fixpoint = true; fixpoint; fixpoint |= Task.this.duration.updateUpperBound(Task.this.end.getUB() - Task.this.start.getLB(), this)) {
                    fixpoint = Task.this.start.updateLowerBound(Task.this.end.getLB() - Task.this.duration.getUB(), this);
                    fixpoint |= Task.this.start.updateUpperBound(Task.this.end.getUB() - Task.this.duration.getLB(), this);
                    fixpoint |= Task.this.end.updateLowerBound(Task.this.start.getLB() + Task.this.duration.getLB(), this);
                    fixpoint |= Task.this.end.updateUpperBound(Task.this.start.getUB() + Task.this.duration.getUB(), this);
                    fixpoint |= Task.this.duration.updateLowerBound(Task.this.end.getLB() - Task.this.start.getUB(), this);
                }
            }

            @Override
            public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
                throw new SolverException("A task cannot explain itself yet.");
            }
        } : new IVariableMonitor(){

            public void onUpdate(Variable var, IEventType evt) throws ContradictionException {
                Task.this.start.updateLowerBound(Task.this.end.getLB() - Task.this.duration.getUB(), this);
                Task.this.start.updateUpperBound(Task.this.end.getUB() - Task.this.duration.getLB(), this);
                Task.this.end.updateLowerBound(Task.this.start.getLB() + Task.this.duration.getLB(), this);
                Task.this.end.updateUpperBound(Task.this.start.getUB() + Task.this.duration.getUB(), this);
                Task.this.duration.updateLowerBound(Task.this.end.getLB() - Task.this.start.getUB(), this);
                Task.this.duration.updateUpperBound(Task.this.end.getUB() - Task.this.start.getLB(), this);
            }

            @Override
            public void explain(ExplanationEngine xengine, Deduction d, Explanation e) {
                throw new SolverException("A task cannot explain itself yet.");
            }
        };
        this.start.addMonitor(this.update);
        this.duration.addMonitor(this.update);
        this.end.addMonitor(this.update);
    }

    public void ensureBoundConsistency() throws ContradictionException {
        this.update.onUpdate(this.start, IntEventType.REMOVE);
    }

    public IntVar getStart() {
        return this.start;
    }

    public void setStart(IntVar start) {
        this.start = start;
    }

    public IntVar getDuration() {
        return this.duration;
    }

    public void setDuration(IntVar duration) {
        this.duration = duration;
    }

    public IntVar getEnd() {
        return this.end;
    }

    public void setEnd(IntVar end) {
        this.end = end;
    }
}

