/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Arrays;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.constraints.IntConstraintFactory;
import org.chocosolver.solver.constraints.real.IntEqRealConstraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.impl.BitsetArrayIntVarImpl;
import org.chocosolver.solver.variables.impl.BitsetIntVarImpl;
import org.chocosolver.solver.variables.impl.BoolVarImpl;
import org.chocosolver.solver.variables.impl.FixedBoolVarImpl;
import org.chocosolver.solver.variables.impl.FixedIntVarImpl;
import org.chocosolver.solver.variables.impl.FixedSetVarImpl;
import org.chocosolver.solver.variables.impl.IntervalIntVarImpl;
import org.chocosolver.solver.variables.impl.RealVarImpl;
import org.chocosolver.solver.variables.impl.SetVarImpl;
import org.chocosolver.solver.variables.view.BoolEqView;
import org.chocosolver.solver.variables.view.BoolNotView;
import org.chocosolver.solver.variables.view.EqView;
import org.chocosolver.solver.variables.view.MinusView;
import org.chocosolver.solver.variables.view.OffsetView;
import org.chocosolver.solver.variables.view.RealView;
import org.chocosolver.solver.variables.view.ScaleView;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class VariableFactory {
    private static final String CSTE_NAME = "cste -- ";
    public static final int MIN_INT_BOUND = -21474836;
    public static final int MAX_INT_BOUND = 21474836;

    VariableFactory() {
    }

    public static BoolVar bool(String NAME, Solver SOLVER) {
        return new BoolVarImpl(NAME, SOLVER);
    }

    public static BoolVar[] boolArray(String NAME, int SIZE, Solver SOLVER) {
        BoolVar[] vars = new BoolVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.bool(NAME + "[" + i + "]", SOLVER);
        }
        return vars;
    }

    public static BoolVar[][] boolMatrix(String NAME, int DIM1, int DIM2, Solver SOLVER) {
        BoolVar[][] vars = new BoolVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.boolArray(NAME + "[" + i + "]", DIM2, SOLVER);
        }
        return vars;
    }

    public static IntVar integer(String NAME, int MIN, int MAX, Solver SOLVER) {
        int size = MAX - MIN + 1;
        if (size < SOLVER.getSettings().getMaxDomSizeForEnumerated()) {
            return VariableFactory.enumerated(NAME, MIN, MAX, SOLVER);
        }
        return VariableFactory.bounded(NAME, MIN, MAX, SOLVER);
    }

    public static IntVar[] integerArray(String NAME, int SIZE, int MIN, int MAX, Solver SOLVER) {
        IntVar[] vars = new IntVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.integer(NAME + "[" + i + "]", MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar[][] integerMatrix(String NAME, int DIM1, int DIM2, int MIN, int MAX, Solver SOLVER) {
        IntVar[][] vars = new IntVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.integerArray(NAME + "[" + i + "]", DIM2, MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar bounded(String NAME, int MIN, int MAX, Solver SOLVER) {
        VariableFactory.checkIntVar(NAME, MIN, MAX);
        if (MIN == MAX) {
            return VariableFactory.fixed(NAME, MIN, SOLVER);
        }
        if (MIN == 0 && MAX == 1) {
            return new BoolVarImpl(NAME, SOLVER);
        }
        return new IntervalIntVarImpl(NAME, MIN, MAX, SOLVER);
    }

    public static IntVar[] boundedArray(String NAME, int SIZE, int MIN, int MAX, Solver SOLVER) {
        IntVar[] vars = new IntVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.bounded(NAME + "[" + i + "]", MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar[][] boundedMatrix(String NAME, int DIM1, int DIM2, int MIN, int MAX, Solver SOLVER) {
        IntVar[][] vars = new IntVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.boundedArray(NAME + "[" + i + "]", DIM2, MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar enumerated(String NAME, int MIN, int MAX, Solver SOLVER) {
        VariableFactory.checkIntVar(NAME, MIN, MAX);
        if (MIN == MAX) {
            return VariableFactory.fixed(NAME, MIN, SOLVER);
        }
        if (MIN == 0 && MAX == 1) {
            return new BoolVarImpl(NAME, SOLVER);
        }
        return new BitsetIntVarImpl(NAME, MIN, MAX, SOLVER);
    }

    public static IntVar[] enumeratedArray(String NAME, int SIZE, int MIN, int MAX, Solver SOLVER) {
        IntVar[] vars = new IntVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.enumerated(NAME + "[" + i + "]", MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar[][] enumeratedMatrix(String NAME, int DIM1, int DIM2, int MIN, int MAX, Solver SOLVER) {
        IntVar[][] vars = new IntVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.enumeratedArray(NAME + "[" + i + "]", DIM2, MIN, MAX, SOLVER);
        }
        return vars;
    }

    public static IntVar enumerated(String NAME, int[] VALUES, Solver SOLVER) {
        VALUES = VariableFactory.sortIfNot((int[])VALUES.clone());
        VariableFactory.checkIntVar(NAME, VALUES[0], VALUES[VALUES.length - 1]);
        if (VALUES.length == 1) {
            return VariableFactory.fixed(NAME, VALUES[0], SOLVER);
        }
        int gap = VALUES[VALUES.length - 1] - VALUES[0];
        if (gap > 30 && gap / VALUES.length > 5) {
            return new BitsetArrayIntVarImpl(NAME, VALUES, SOLVER);
        }
        return new BitsetIntVarImpl(NAME, VALUES, SOLVER);
    }

    public static IntVar[] enumeratedArray(String NAME, int SIZE, int[] VALUES, Solver SOLVER) {
        IntVar[] vars = new IntVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.enumerated(NAME + "[" + i + "]", VALUES, SOLVER);
        }
        return vars;
    }

    public static IntVar[][] enumeratedMatrix(String NAME, int DIM1, int DIM2, int[] VALUES, Solver SOLVER) {
        IntVar[][] vars = new IntVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.enumeratedArray(NAME + "[" + i + "]", DIM2, VALUES, SOLVER);
        }
        return vars;
    }

    public static RealVar real(String NAME, double MIN, double MAX, double PRECISION, Solver SOLVER) {
        VariableFactory.checkRealVar(NAME, MIN, MAX);
        return new RealVarImpl(NAME, MIN, MAX, PRECISION, SOLVER);
    }

    public static RealVar[] realArray(String NAME, int SIZE, double MIN, double MAX, double PRECISION, Solver SOLVER) {
        RealVar[] vars = new RealVar[SIZE];
        for (int i = 0; i < SIZE; ++i) {
            vars[i] = VariableFactory.real(NAME + "[" + i + "]", MIN, MAX, PRECISION, SOLVER);
        }
        return vars;
    }

    public static RealVar[][] realMatrix(String NAME, int DIM1, int DIM2, double MIN, double MAX, double PRECISION, Solver SOLVER) {
        RealVar[][] vars = new RealVar[DIM1][];
        for (int i = 0; i < DIM1; ++i) {
            vars[i] = VariableFactory.realArray(NAME + "[" + i + "]", DIM2, MIN, MAX, PRECISION, SOLVER);
        }
        return vars;
    }

    public static SetVar set(String NAME, int[] ENVELOPE, SetType ENV_TYPE, int[] KERNEL, SetType KER_TYPE, Solver SOLVER) {
        return new SetVarImpl(NAME, ENVELOPE, ENV_TYPE, KERNEL, KER_TYPE, SOLVER);
    }

    public static SetVar set(String NAME, int[] ENVELOPE, int[] KERNEL, Solver SOLVER) {
        return VariableFactory.set(NAME, ENVELOPE, SetType.BITSET, KERNEL, SetType.BITSET, SOLVER);
    }

    public static SetVar set(String NAME, int[] ENVELOPE, Solver SOLVER) {
        return VariableFactory.set(NAME, ENVELOPE, SetType.BITSET, new int[0], SetType.BITSET, SOLVER);
    }

    public static SetVar set(String NAME, int MIN_ELEMENT, int MAX_ELEMENT, Solver SOLVER) {
        return new SetVarImpl(NAME, MIN_ELEMENT, MAX_ELEMENT, SOLVER);
    }

    public static Task task(IntVar START, IntVar DURATION, IntVar END) {
        return new Task(START, DURATION, END);
    }

    public static IntVar[] castToIntVar(Variable ... VARIABLES) {
        IntVar[] ivars = new IntVar[VARIABLES.length];
        for (int i = 0; i < VARIABLES.length; ++i) {
            ivars[i] = (IntVar)VARIABLES[i];
        }
        return ivars;
    }

    public static IntVar[][] toMatrix(IntVar[] VARS, int DIM1, int DIM2) {
        IntVar[][] mat = new IntVar[DIM1][DIM2];
        for (int i = 0; i < DIM1; ++i) {
            for (int j = 0; j < DIM2; ++j) {
                mat[i][j] = VARS[i + j * DIM1];
            }
        }
        return mat;
    }

    private static void checkIntVar(String NAME, int MIN, int MAX) {
        if (MIN - Integer.MIN_VALUE == 0 || MAX - Integer.MAX_VALUE == 0) {
            throw new SolverException(NAME + ": consider reducing the bounds to avoid unexpected results");
        }
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
    }

    private static int[] sortIfNot(int[] values) {
        int n = values.length;
        boolean sorted = true;
        boolean noDouble = true;
        for (int i = 0; i < n - 1 && sorted; ++i) {
            if (values[i] > values[i + 1]) {
                sorted = false;
                noDouble = false;
            }
            if (values[i] != values[i + 1]) continue;
            noDouble = false;
        }
        if (!sorted) {
            Arrays.sort(values);
        }
        if (!noDouble) {
            int nbVals = 1;
            for (int i = 0; i < n - 1; ++i) {
                assert (values[i] <= values[i + 1]);
                if (values[i] >= values[i + 1]) continue;
                ++nbVals;
            }
            if (nbVals < n) {
                int[] correctValues = new int[nbVals];
                int idx = 0;
                for (int i = 0; i < n - 1; ++i) {
                    if (values[i] >= values[i + 1]) continue;
                    correctValues[idx++] = values[i];
                }
                correctValues[idx] = values[n - 1];
                return correctValues;
            }
        }
        return values;
    }

    private static void checkRealVar(String NAME, double MIN, double MAX) {
        if (MAX < MIN) {
            throw new SolverException(NAME + ": wrong domain definition, lower bound > upper bound");
        }
    }

    public static IntVar fixed(int VALUE, Solver SOLVER) {
        return VariableFactory.fixed(CSTE_NAME + VALUE, VALUE, SOLVER);
    }

    public static BoolVar zero(Solver SOLVER) {
        return SOLVER.ZERO;
    }

    public static BoolVar one(Solver SOLVER) {
        return SOLVER.ONE;
    }

    public static IntVar fixed(String NAME, int VALUE, Solver SOLVER) {
        if (NAME.equals(CSTE_NAME + VALUE) && SOLVER.cachedConstants.containsKey(VALUE)) {
            return SOLVER.cachedConstants.get(VALUE);
        }
        FixedIntVarImpl cste = VALUE == 0 || VALUE == 1 ? new FixedBoolVarImpl(NAME, VALUE, SOLVER) : new FixedIntVarImpl(NAME, VALUE, SOLVER);
        if (NAME.equals(CSTE_NAME + VALUE)) {
            SOLVER.cachedConstants.put(VALUE, cste);
        }
        return cste;
    }

    public static IntVar fixed(boolean VALUE, Solver SOLVER) {
        if (VALUE) {
            return SOLVER.ONE;
        }
        return SOLVER.ZERO;
    }

    public static SetVar fixed(String NAME, int[] VALUE, Solver SOLVER) {
        return new FixedSetVarImpl(NAME, VALUE, SOLVER);
    }

    public static IntVar offset(IntVar VAR, int CSTE) {
        if (CSTE == 0) {
            return VAR;
        }
        if (VAR.getSolver().getSettings().enableViews()) {
            return new OffsetView(VAR, CSTE, VAR.getSolver());
        }
        Solver s = VAR.getSolver();
        int lb = VAR.getLB() + CSTE;
        int ub = VAR.getUB() + CSTE;
        String name = "(" + VAR.getName() + "+" + CSTE + ")";
        IntVar ov = VAR.hasEnumeratedDomain() ? VariableFactory.enumerated(name, lb, ub, s) : VariableFactory.bounded(name, lb, ub, s);
        s.post(ICF.arithm(ov, "-", VAR, "=", CSTE));
        return ov;
    }

    public static IntVar eq(IntVar VAR) {
        if ((VAR.getTypeAndKind() & 0xF8) == 24) {
            return VariableFactory.eqbool((BoolVar)VAR);
        }
        return VariableFactory.eqint(VAR);
    }

    public static BoolVar eq(BoolVar VAR) {
        return VariableFactory.eqbool(VAR);
    }

    private static IntVar eqint(IntVar ivar) {
        if (ivar.getSolver().getSettings().enableViews()) {
            return new EqView(ivar, ivar.getSolver());
        }
        IntVar ov = (IntVar)ivar.duplicate();
        ivar.getSolver().post(ICF.arithm(ov, "=", ivar));
        return ov;
    }

    private static BoolVar eqbool(BoolVar BOOL) {
        if (BOOL.getSolver().getSettings().enableViews()) {
            return new BoolEqView(BOOL, BOOL.getSolver());
        }
        BoolVar ov = (BoolVar)BOOL.duplicate();
        BOOL.getSolver().post(ICF.arithm((IntVar)ov, "=", BOOL));
        if (BOOL.hasNot()) {
            ov._setNot(BOOL.not());
        }
        ov.setNot(BOOL.isNot());
        return ov;
    }

    public static BoolVar not(BoolVar BOOL) {
        if (BOOL.getSolver().getSettings().enableViews()) {
            return new BoolNotView(BOOL, BOOL.getSolver());
        }
        if (BOOL.hasNot()) {
            return BOOL.not();
        }
        Solver s = BOOL.getSolver();
        BoolVar ov = VariableFactory.bool("not(" + BOOL.getName() + ")", s);
        s.post(ICF.arithm((IntVar)ov, "!=", BOOL));
        BOOL._setNot(ov);
        ov._setNot(BOOL);
        ov.setNot(true);
        return ov;
    }

    public static IntVar minus(IntVar VAR) {
        if (VAR.getSolver().getSettings().enableViews()) {
            return new MinusView(VAR, VAR.getSolver());
        }
        Solver s = VAR.getSolver();
        int ub = -VAR.getLB();
        int lb = -VAR.getUB();
        String name = "-(" + VAR.getName() + ")";
        IntVar ov = VAR.hasEnumeratedDomain() ? VariableFactory.enumerated(name, lb, ub, s) : VariableFactory.bounded(name, lb, ub, s);
        s.post(ICF.arithm(ov, "+", VAR, "=", 0));
        return ov;
    }

    public static IntVar scale(IntVar VAR, int CSTE) {
        IntVar var;
        if (CSTE == -1) {
            return VariableFactory.minus(VAR);
        }
        if (CSTE < 0) {
            throw new UnsupportedOperationException("scale required positive coefficient!");
        }
        if (CSTE == 0) {
            var = VariableFactory.fixed(0, VAR.getSolver());
        } else if (CSTE == 1) {
            var = VAR;
        } else if (VAR.getSolver().getSettings().enableViews()) {
            var = new ScaleView(VAR, CSTE, VAR.getSolver());
        } else {
            Solver s = VAR.getSolver();
            int lb = VAR.getLB() * CSTE;
            int ub = VAR.getUB() * CSTE;
            String name = "(" + VAR.getName() + "*" + CSTE + ")";
            IntVar ov = VAR.hasEnumeratedDomain() ? VariableFactory.enumerated(name, lb, ub, s) : VariableFactory.bounded(name, lb, ub, s);
            s.post(ICF.times(VAR, CSTE, ov));
            return ov;
        }
        return var;
    }

    public static IntVar abs(IntVar VAR) {
        if (VAR.isInstantiated()) {
            return VariableFactory.fixed(Math.abs(VAR.getValue()), VAR.getSolver());
        }
        if (VAR.getLB() >= 0) {
            return VAR;
        }
        if (VAR.getUB() <= 0) {
            return VariableFactory.minus(VAR);
        }
        Solver s = VAR.getSolver();
        int ub = Math.max(-VAR.getLB(), VAR.getUB());
        String name = "|" + VAR.getName() + "|";
        IntVar abs = VAR.hasEnumeratedDomain() ? VariableFactory.enumerated(name, 0, ub, s) : VariableFactory.bounded(name, 0, ub, s);
        s.post(IntConstraintFactory.absolute(abs, VAR));
        return abs;
    }

    public static RealVar real(IntVar VAR, double PRECISION) {
        if (VAR.getSolver().getSettings().enableViews()) {
            return new RealView(VAR, PRECISION);
        }
        Solver s = VAR.getSolver();
        double lb = VAR.getLB();
        double ub = VAR.getUB();
        RealVar rv = VariableFactory.real("(real)" + VAR.getName(), lb, ub, PRECISION, s);
        s.post((Constraint)new IntEqRealConstraint(VAR, rv, PRECISION));
        return rv;
    }

    public static RealVar[] real(IntVar[] VARS, double PRECISION) {
        RealVar[] reals = new RealVar[VARS.length];
        if (VARS[0].getSolver().getSettings().enableViews()) {
            for (int i = 0; i < VARS.length; ++i) {
                reals[i] = VariableFactory.real(VARS[i], PRECISION);
            }
        } else {
            Solver s = VARS[0].getSolver();
            for (int i = 0; i < VARS.length; ++i) {
                double lb = VARS[i].getLB();
                double ub = VARS[i].getUB();
                reals[i] = VariableFactory.real("(real)" + VARS[i].getName(), lb, ub, PRECISION, s);
            }
            s.post((Constraint)new IntEqRealConstraint(VARS, reals, PRECISION));
        }
        return reals;
    }
}

