/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IEnumDelta;

public final class EnumDelta
extends TimeStampedObject
implements IEnumDelta {
    private static final int SIZE = 32;
    int[] rem = new int[32];
    ICause[] causes = new ICause[32];
    int last;

    public EnumDelta(ISearchLoop loop) {
        super(loop);
    }

    private void ensureCapacity() {
        if (this.last >= this.rem.length) {
            int[] tmp = new int[this.last * 3 / 2 + 1];
            ICause[] tmpc = new ICause[this.last * 3 / 2 + 1];
            System.arraycopy(this.rem, 0, tmp, 0, this.last);
            System.arraycopy(this.causes, 0, tmpc, 0, this.last);
            this.rem = tmp;
            this.causes = tmpc;
        }
    }

    @Override
    public void lazyClear() {
        if (this.needReset()) {
            this.last = 0;
            this.resetStamp();
        }
    }

    @Override
    public void add(int value, ICause cause) {
        this.lazyClear();
        this.ensureCapacity();
        this.causes[this.last] = cause;
        this.rem[this.last++] = value;
    }

    @Override
    public int get(int idx) {
        return this.rem[idx];
    }

    @Override
    public ICause getCause(int idx) {
        return this.causes[idx];
    }

    @Override
    public int size() {
        return this.last;
    }
}

