/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.ISearchLoop;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IIntervalDelta;

public final class IntervalDelta
extends TimeStampedObject
implements IIntervalDelta {
    private static final int SIZE = 32;
    int[] from = new int[32];
    int[] to = new int[32];
    ICause[] causes = new ICause[32];
    int last;

    public IntervalDelta(ISearchLoop loop) {
        super(loop);
    }

    private void ensureCapacity() {
        if (this.last >= this.from.length) {
            int[] tmp = new int[this.last * 3 / 2 + 1];
            System.arraycopy(this.from, 0, tmp, 0, this.last);
            this.from = tmp;
            tmp = new int[this.last * 3 / 2 + 1];
            System.arraycopy(this.to, 0, tmp, 0, this.last);
            this.to = tmp;
            ICause[] tmpc = new ICause[this.last * 3 / 2 + 1];
            System.arraycopy(this.causes, 0, tmpc, 0, this.last);
            this.causes = tmpc;
        }
    }

    @Override
    public void lazyClear() {
        if (this.needReset()) {
            this.last = 0;
            this.resetStamp();
        }
    }

    @Override
    public void add(int lb, int ub, ICause cause) {
        this.lazyClear();
        this.ensureCapacity();
        this.causes[this.last] = cause;
        this.from[this.last] = lb;
        this.to[this.last++] = ub;
    }

    @Override
    public int getLB(int idx) {
        return this.from[idx];
    }

    @Override
    public int getUB(int idx) {
        return this.to[idx];
    }

    @Override
    public ICause getCause(int idx) {
        return this.causes[idx];
    }

    @Override
    public int size() {
        return this.last;
    }
}

